/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.exception;

import java.util.Optional;
import org.springframework.dao.DuplicateKeyException;

public class DuplicateUniqueKeyPersistentException
extends RuntimeException {
    private String uniqueKey;
    private String uniqueKeyField;

    public DuplicateUniqueKeyPersistentException(Throwable cause, String message, Object ... params) {
        super(String.format(message, params), cause);
    }

    private DuplicateUniqueKeyPersistentException fillStringFromJdbc4Exception(Optional<String> messageOptional) {
        String split = "' for key '";
        DuplicateUniqueKeyPersistentException.findStringBetween(messageOptional, "Duplicate entry '", "'").map(input -> input.split(split)).filter(items -> ((String[])items).length == 2).ifPresent(items -> {
            this.uniqueKey = items[0];
            this.uniqueKeyField = items[1];
        });
        return this;
    }

    private static Optional<String> findStringBetween(Optional<String> inputOptional, String prefix, String suffix) {
        return inputOptional.filter(input -> input.startsWith(prefix)).filter(input -> input.endsWith(suffix)).map(input -> input.substring(prefix.length(), input.length() - suffix.length()));
    }

    public DuplicateUniqueKeyPersistentException fillStringExceptionDuplicateKey(DuplicateKeyException springException) {
        Optional.ofNullable(springException.getCause()).ifPresent(jdbcExceptionInstance -> {
            String className;
            switch (className = jdbcExceptionInstance.getClass().getName()) {
                case "com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException": {
                    this.fillStringFromJdbc4Exception(Optional.ofNullable(jdbcExceptionInstance.getMessage()));
                }
            }
        });
        return this;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public String getUniqueKeyField() {
        return this.uniqueKeyField;
    }

    public void setUniqueKeyField(String uniqueKeyField) {
        this.uniqueKeyField = uniqueKeyField;
    }
}

