/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.ranking.bean;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.ranking.bean.StatisticsRankingTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class RankingElementSummationAmount<A extends RankingElementSummationAmount<A>>
implements OneStatisticsResult {
    private StatisticsResultMeta resultMeta;
    private ForkQueryProcess process;
    private String countKey;
    private Double sorterScore;

    @Override
    public void clearRedundancyFields() {
    }

    public abstract double countSorterScore();

    protected abstract void mergeOtherHandleImplElement(A var1);

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(this.resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public void mergeOther(A other) {
        this.mergeOtherHandleImplElement(other);
        this.sorterScore = this.countSorterScore();
    }

    public abstract <E extends Throwable> void validateOriginComplete(Function<String, E> var1) throws E;

    public void accumulateOther(A other) {
        Function<String, ServerException> supplier = message -> new ServerException(Status.Server.programConfigJava, "\u505a\u6570\u636e\u7d2f\u52a0\u7684\u65f6\u5019\u51fa\u9519:%s", new Object[]{message});
        this.validateOriginComplete(supplier);
        ((RankingElementSummationAmount)other).validateOriginComplete(supplier);
        this.mergeOtherHandleImplElement(other);
        this.resetSorter();
    }

    public void resetSorter() {
        this.sorterScore = this.countSorterScore();
    }

    public <E extends Throwable> void validateComplete(Function<String, E> exceptionSupplier) throws E {
        this.validateOriginComplete(exceptionSupplier);
        this.resetSorter();
        if (this.sorterScore == null) {
            throw (Throwable)exceptionSupplier.apply("sorter \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.countKey == null) {
            throw (Throwable)exceptionSupplier.apply("countKey \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public RankingElementSummationAmount() {
    }

    public RankingElementSummationAmount(String countKey, Double sorter) {
        this.countKey = countKey;
        this.sorterScore = sorter;
    }

    public static <E extends RankingElementSummationAmount<E>> E accumulate(Map.Entry<String, List<E>> keyAmounts, Function<String, E> emptyFunction) {
        return RankingElementSummationAmount.accumulate(keyAmounts.getKey(), keyAmounts.getValue(), emptyFunction);
    }

    public static <E extends RankingElementSummationAmount<E>> E accumulate(String countKey, List<E> amounts, Function<String, E> emptyFunction) {
        RankingElementSummationAmount master = (RankingElementSummationAmount)emptyFunction.apply(countKey);
        amounts.stream().forEach(master::accumulateOther);
        return (E)master;
    }

    public static <E extends RankingElementSummationAmount<E>> Comparator<E> rankingSorterDesc() {
        return Comparator.comparing(amount -> -amount.getSorterScore().doubleValue());
    }

    public static <E extends RankingElementSummationAmount<E>> Comparator<E> rankingSorter() {
        return Comparator.comparing(RankingElementSummationAmount::getSorterScore);
    }

    public static <E extends RankingElementSummationAmount<E>> E copyNewInstance(Function<String, E> instanceSupplier, E other) {
        RankingElementSummationAmount instance = (RankingElementSummationAmount)instanceSupplier.apply(other.getCountKey());
        instance.mergeOther(other);
        return (E)instance;
    }

    public boolean matchKey(A amount) {
        return this.matchKey(((RankingElementSummationAmount)amount).getCountKey());
    }

    public boolean matchKey(String countKey) {
        AssertUtil.assertNotFatalProgramConfig(this.countKey != null, Status.Server.programConfigJava, "\u5f53\u524d\u5bf9\u8c61\u4e2dcountKey\u4e3a\u7a7athis:%s", this);
        return this.countKey.equals(countKey);
    }

    public static Gson createGsonBean(RankingElementSummationAmount<?> amount) {
        return amount.createGsonBuilder().create();
    }

    protected abstract StatisticsRankingTable<A> deserializeJsonRankingTable(String var1);

    public GsonBuilder createGsonBuilder() {
        return new GsonBuilder();
    }

    public static <E extends RankingElementSummationAmount<E>> String serializeList(List<E> amounts, E bean) {
        return RankingElementSummationAmount.createGsonBean(bean).toJson(amounts);
    }

    public static <E extends RankingElementSummationAmount<E>> List<E> deserializeList(String serializeString, E bean) {
        Gson gson = RankingElementSummationAmount.createGsonBean(bean);
        JsonArray array = new JsonParser().parse(serializeString).getAsJsonArray();
        ArrayList list = new ArrayList();
        Class<?> clazz = bean.getClass();
        array.forEach(jsonElement -> {
            RankingElementSummationAmount element = (RankingElementSummationAmount)gson.fromJson(jsonElement, clazz);
            list.add(element);
        });
        return list;
    }

    public static <E extends RankingElementSummationAmount<E>> void accumulateOtherList(List<E> masterList, List<E> slaverList) {
        slaverList.stream().forEach(slaver -> {
            Optional<RankingElementSummationAmount> masterOptional = masterList.stream().filter(master -> master.matchKey(slaver)).findFirst();
            masterOptional.ifPresent(master -> master.accumulateOther(slaver));
            if (!masterOptional.isPresent()) {
                masterList.add(slaver);
            }
        });
        masterList.sort(RankingElementSummationAmount.rankingSorterDesc());
    }

    public static <E extends RankingElementSummationAmount<E>> List<E> accumulateRankings(List<E> ranking1, List<E> ranking2) {
        return RankingElementSummationAmount.accumulateAllRanking(Stream.of(ranking1, ranking2).collect(Collectors.toList()));
    }

    public static <E extends RankingElementSummationAmount<E>> List<E> accumulateAllRanking(List<List<E>> rankingList) {
        ArrayList result = new ArrayList();
        rankingList.forEach(elements -> RankingElementSummationAmount.accumulateOtherList(result, elements));
        result.sort(RankingElementSummationAmount.rankingSorterDesc());
        return result;
    }

    public StatisticsResultMeta getResultMeta() {
        return this.resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(this.process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public String getCountKey() {
        return this.countKey;
    }

    public void setCountKey(String countKey) {
        this.countKey = countKey;
    }

    public Double getSorterScore() {
        return this.sorterScore;
    }

    public void setSorterScore(Double sorterScore) {
        this.sorterScore = sorterScore;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

