/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.sql.view.database;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.params.MapParams;
import com.mini.framework.util.sql.view.database.DatabaseSchemeType;
import com.mini.framework.util.string.RegexUtil;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public enum PaasDatabaseName {
    tdtPaas("\u4ea4\u6613\u8ffd\u8e2a\u7684\u603b\u5546\u5bb6", DatabaseSchemeType.tdt, false),
    mallPaas("\u5546\u57ce\u7684\u603b\u5546\u5bb6", DatabaseSchemeType.mall, false),
    schoolPaas("\u5b66\u9662\u7684\u603b\u5546\u5bb6", DatabaseSchemeType.school, false),
    mshowPaas("\u5a92\u4f53\u79c0\u7684\u603b\u5546\u5bb6", DatabaseSchemeType.mshow, false),
    tdtSite("\u4ea4\u6613\u8ffd\u8e2a\u7684\u4e00\u4e2a\u5546\u5bb6", DatabaseSchemeType.tdt, true),
    mallSite("\u5546\u57ce\u7684\u4e00\u4e2a\u5546\u5bb6", DatabaseSchemeType.mall, true),
    schoolSite("\u5b66\u9662\u7684\u4e00\u4e2a\u5546\u5bb6", DatabaseSchemeType.school, true),
    mshowSite("\u5a92\u4f53\u79c0\u7684\u4e00\u4e2a\u5546\u5bb6", DatabaseSchemeType.mshow, true);

    private String title;
    private DatabaseSchemeType type;
    private Boolean requireSiteKey;

    private PaasDatabaseName(String title, DatabaseSchemeType type, Boolean requireSiteKey) {
        this.title = title;
        this.type = type;
        this.requireSiteKey = requireSiteKey;
    }

    public String getTitle() {
        return this.title;
    }

    public DatabaseSchemeType getType() {
        return this.type;
    }

    public Boolean getRequireSiteKey() {
        return this.requireSiteKey;
    }

    public boolean ifRequireSiteKey() {
        return this.getRequireSiteKey();
    }

    public boolean ifNotRequireSiteKey() {
        return !this.ifRequireSiteKey();
    }

    public <S> Optional<String> queryDatabaseName(Optional<S> siteKeyOptional, Function<DatabaseSchemeType, Optional<String>> paasNameFinder, BiFunction<DatabaseSchemeType, S, Optional<String>> siteNameFinder) {
        AssertUtil.assertMethodRequire(siteKeyOptional, "siteKeyOptional");
        if (this.requireSiteKey.booleanValue()) {
            S siteKey = siteKeyOptional.orElseThrow(() -> new ServerException(Status.Server.programConfigJava, "\u679a\u4e3e:[%s]\u5fc5\u987b\u6307\u660e\u5546\u5bb6key", new Object[]{this}));
            return siteNameFinder.apply(this.type, siteKey);
        }
        return paasNameFinder.apply(this.type);
    }

    public static <S> String replacePlaceHolder(String origin, Optional<S> siteKeyOptional, Function<DatabaseSchemeType, Optional<String>> paasNameFinder, BiFunction<DatabaseSchemeType, S, Optional<String>> siteNameFinder, Function<String, String> defaultValueFunction) {
        AssertUtil.assertMethodRequire(siteKeyOptional, "siteKeyOptional");
        MapParams params = MapParams.build();
        Stream.of(PaasDatabaseName.values()).filter(nameType -> nameType.ifNotRequireSiteKey() || siteKeyOptional.isPresent()).forEach(nameType -> {
            Optional<String> databaseNameOptional = nameType.queryDatabaseName(siteKeyOptional, paasNameFinder, siteNameFinder);
            databaseNameOptional.ifPresent(databaseName -> params.param(nameType.name(), databaseName));
        });
        return RegexUtil.applyPlaceholder(origin, (Map<String, Object>)params, key -> {
            throw new ServerException(Status.Server.fatalBug, "\u5360\u4f4dkey:[%s]\u627e\u4e0d\u5230\u5546\u5bb6:[%s]\u5e93\u540d", new Object[]{key, siteKeyOptional.map(o -> o).orElse("none")});
        });
    }
}

