/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.bean.BeanUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.Xpp3Driver;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class XStreamUtil {
    public static String toXml(Object bean) {
        XStream xstream = XStreamUtil.simpleXStream();
        xstream.processAnnotations(bean.getClass());
        String xml = xstream.toXML(bean);
        return xml;
    }

    public static XStream simpleXStream() {
        XStream xstream = new XStream((HierarchicalStreamDriver)new Xpp3Driver((NameCoder)new NoNameCoder()));
        XStream.setupDefaultSecurity((XStream)xstream);
        xstream.autodetectAnnotations(true);
        xstream.ignoreUnknownElements();
        return xstream;
    }

    public static Map<String, String> beanToMap(Object bean) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field field : BeanUtil.getAllField(bean)) {
            field.setAccessible(true);
            String fieldName = field.getName();
            XStreamAlias xStreamAlias = field.getAnnotation(XStreamAlias.class);
            if (xStreamAlias != null) {
                fieldName = xStreamAlias.value();
            }
            try {
                Object val = field.get(bean);
                String value = val == null ? null : String.valueOf(val);
                map.put(fieldName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new HandleEnDeCodeException((Throwable)e, "%s\u5728\u751f\u6210map\u65f6\u51fa\u9519", new Object[]{bean});
            }
        }
        return map;
    }

    public static <B> B fromXml(String xml, Class<B> clazz) {
        XStream xstream = XStreamUtil.simpleXStream();
        xstream.allowTypes(new Class[]{clazz});
        xstream.processAnnotations(clazz);
        Object bean = xstream.fromXML(xml);
        return (B)bean;
    }
}

