/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.bean.BeanUtil;
import com.mini.framework.util.string.gson.deserializer.GsonUnknownType;
import com.mini.framework.util.string.gson.deserializer.GsonUnknownTypeable;
import com.mini.framework.util.string.gson.deserializer.UnknownTypeHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;

public class UnknownTypeInBeanDeserializer<B extends GsonUnknownTypeable<B>>
implements JsonDeserializer<B>,
UnknownTypeHelper {
    private Class<B> clazz;

    public UnknownTypeInBeanDeserializer(Class<B> clazz) {
        this.clazz = clazz;
    }

    public B deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        B instance = null;
        try {
            instance = ((GsonUnknownTypeable)this.clazz.newInstance()).fromJsonElement(this.clazz, json);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServerException((Throwable)e, Status.Server.programConfigJava, "\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25:%s", new Object[]{this.clazz});
        }
        HashMap map = new HashMap();
        this.fillUnknownValueToMap(json, map);
        List<Field> fields = BeanUtil.getAllField(instance);
        for (Field field : fields) {
            GsonUnknownType type = field.getAnnotation(GsonUnknownType.class);
            if (type == null) continue;
            Object value = map.get(field.getName());
            try {
                if (value == null) continue;
                field.setAccessible(true);
                field.set(instance, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new ServerException((Throwable)e, Status.Server.programConfigJava, "\u5f02\u5e38\u5f85\u8bf4\u660e", new Object[0]);
            }
        }
        return instance;
    }
}

