package com.mini.framework.util.bean;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.HandleReflectException;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/**
 * 类工具。
 * @author jayheo
 */
public class ClassUtil {

	/**
	 * 从包中找到所有的类
	 * @see #findClassFromPackage(Package)
	 * @param pack
	 * @return
	 */
	@Deprecated
	public static List<Class<?>> getClassFromPackage(Package pack) {
		String packageString = pack.getName();
		String name = packageString.replace(".", "/");
		String packageDir = ClassLoader.getSystemClassLoader().getResource(name).getPath();
		File[] files = new File(packageDir).listFiles();
		List<Class<?>> classes = Stream.of(files).map(File::getName).filter(n -> n.endsWith("class"))
				.map(n -> packageString + "." + n.replace(".class", "")).map(className -> {
					try {
						return Class.forName(className);
					} catch (ClassNotFoundException e) {
						throw new BadReqException(e, "找不到类:%s", className);
					}
				}).collect(Collectors.toList());
		;
		return classes;
	}


	/**
	 * 通过查询包含的类。
	 * @param pack
	 * @return
	 */
	public static List<Class<?>> findClassFromPackage(Package pack){
		return findClassFromPackage(pack.getName());
	}

	/**
	 * 通过查询包含的类。
	 * @param clazz 类
	 * @return
	 */
	public static  List<Class<?>> findClassFromPackageOfClass(Class<?> clazz){
		String className = clazz.getName();
		String packageName = StringUtils.substringBeforeLast(className, ".");
		return findClassFromPackage(packageName);
	}

	/**
	 * 通过查询包含的类。
	 * @param classInstance 类的实例
	 * @return
	 */
	public static List<Class<?>> findClassFromPackageOfClassInstance(Object classInstance){
		String className = classInstance.getClass().getName();
		String packageName = StringUtils.substringBeforeLast(className, ".");
		return findClassFromPackage(packageName);
	}





	/**
	 * 从包路径查询包含的类。
	 * @param packageClassPath 例如 com.mini.framework
	 * @return
	 */
	public static <B> List<Class<?>> findClassFromPackage(String packageClassPath){
		String packageFilePath = packageClassPath.replace(".","/");
		String packagePattern = String.format("classpath*:%s/*",packageClassPath.replace(".","/"));
		Resource[] resources = getResourcesByPathPattern(packagePattern);
		return Stream.of(resources).map(Resource::toString)
				.map(resourcePath-> resourcePath.replace("\\","/"))
				.filter(classFilePath->classFilePath.contains(".class"))
				.map(resourcePath->{
			String fileNameWithSuffix = StringUtils.substringAfter(resourcePath, packageFilePath);
			String classNameWithSplit = StringUtils.substringBeforeLast(fileNameWithSuffix, ".class");
			return packageFilePath + classNameWithSplit;
		}).map(classFilePath->classFilePath.replace("/","."))
		.map(classPath-> {
			try {
				return Class.forName(classPath);
			} catch (ClassNotFoundException e) {
				throw new HandleReflectException(e,"根据类:[%s]解析成类出错",classPath);
			}
		}).collect(Collectors.toList());
		
	}
	
	public static Resource[] getResourcesByPathPattern(String pathPattern){
		try {
			return new PathMatchingResourcePatternResolver().getResources(pathPattern);
		} catch (IOException e) {
			throw new HandleIOException(e,"根据路径正则:[%s]获取资源出错",pathPattern);
		}
	}
	

}
