package com.mini.framework.util.bean.desc;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mini.framework.util.string.GsonUtil;
import com.mini.framework.util.string.gson.DateMilliSecondSerializer;

public class DescUtil {
	
	private static final String defaultDescPrefix = Descable.defaultDescPrefix;

	private static String toJsonWithValue(Object object){
		return toJsonWithValue(object, defaultDescPrefix);
	}
	
	/**
	 * 转成json并附带原来的值
	 * @param nameSuffix
	 * @return
	 */
	private static String toJsonWithValue(Object object,String nameSuffix){
		
		return buildGson().toJson(object);
	}
	
	
	private static Gson buildGson(){
		
		List<Gson> list = new ArrayList<Gson>();
		
		Supplier<Gson> gsonSupplier = ()-> list.get(0);
		
		GsonBuilder builder = new GsonBuilder().setDateFormat(DateFormat.LONG)
		.registerTypeAdapter(Date.class, new DateMilliSecondSerializer())
		.registerTypeHierarchyAdapter(Descable.class, new DescSerializer(defaultDescPrefix,gsonSupplier,"未发现描述"))
		.disableHtmlEscaping();
		Gson gson = builder.create();
		list.add(gson);
		return gson;
	}
	
	
	public static FieldDesc getDesces(Field field,String nullDesc){
		Optional<Desc> descOptional = Optional.ofNullable(field.getAnnotation(Desc.class));
		Optional<RoleDesc> roleDescOptional = Optional.ofNullable(field.getAnnotation(RoleDesc.class));
		Class<?> type = field.getType();
		
		String typeName = type.getName();
		 FieldDesc desc = new FieldDesc(field.getName()
				 ,typeName
				 ,descOptional.map(Desc::value).orElse(nullDesc)
				 ,roleDescOptional.map(RoleDesc::required).orElse(null)
				 ,roleDescOptional.map(RoleDesc::lengthLimit).orElse(null)
				 );
		 if(null!=type.getDeclaredAnnotation(Desc.class)){
			 desc.setTypeDesc(type.getDeclaredAnnotation(Desc.class).value());
		 }
		 
		 if(type.isEnum()){
			 Field[] fields = type.getFields();
			 fields[0].getName();
			 List<FieldOptionDesc> options = Stream.of(fields).map(f->FieldOptionDesc.fromField(f, nullDesc)).collect(Collectors.toList());
			desc.setOptions(options );
		 }
		 return desc;
	}
	
}
