package com.mini.framework.util.bean.desc;

import java.util.ArrayList;
import java.util.List;

public class FieldDesc {

	private String name;

	private String desc;
	
	/**
	 * 属性类型
	 */
	private String type;
	
	private String typeDesc;
	
	
	
	/**
	 * 可选的
	 */
	private List<FieldOptionDesc> options;
	
	private Boolean required;
	
	private Integer lengthLimit;

	public FieldDesc() {
		super();
	}

	public FieldDesc(String name,String type, String desc, Boolean required, Integer lengthLimit) {
		super();
		this.name = name;
		this.type = type;
		this.desc = desc;
		this.required = required;
		this.lengthLimit = lengthLimit;
	}


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public Boolean getRequired() {
		return required;
	}

	public void setRequired(Boolean required) {
		this.required = required;
	}

	public Integer getLengthLimit() {
		return lengthLimit;
	}

	public void setLengthLimit(Integer lengthLimit) {
		this.lengthLimit = lengthLimit;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public List<FieldOptionDesc> getOptions() {
		return options;
	}

	public void setOptions(List<FieldOptionDesc> options) {
		this.options = options;
	}
	
	public String getTypeDesc() {
		return typeDesc;
	}

	public void setTypeDesc(String typeDesc) {
		this.typeDesc = typeDesc;
	}

	public FieldDesc addOptions(FieldOptionDesc... options){
		if(this.options==null){
			this.options = new ArrayList<>();
		}
		for (FieldOptionDesc fieldOptionDesc : options) {
			this.options.add(fieldOptionDesc);
		}
		return this;
	}
}
