package com.mini.framework.util.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.core.exception.standard.UnsupportedException;

/**
 * 多个商家线程持有
 * @author jayheo
 *
 * @param <T>
 */
public class MultiIntSiteHoldSupplier<T> extends HoldSupplier<T> {


	protected Supplier<Integer> siteIdSupplier;
	
	protected Map<Integer, T> holds = new ConcurrentHashMap<>();
	
	public MultiIntSiteHoldSupplier(Supplier<Integer> siteIdSupplier, Supplier<T> supplier) {
		super(supplier);
		AssertUtil.assertSupport(siteIdSupplier!=null,"siteIdSupplier不能为空");
		this.siteIdSupplier = siteIdSupplier;
	}
	

	/**
	 * @see MultiIntSiteHoldSupplier#create(Supplier, Supplier)
	 * @param supplier
	 * @return
	 */
	public static <T> HoldSupplier<T> create(Supplier<T> supplier) {
		throw new UnsupportedException("不允许使这个方法");
	}

	public static <T> HoldSupplier<T> create(Supplier<Integer> siteIdSupplier, Supplier<T> supplier) {
		return new MultiIntSiteHoldSupplier<>(siteIdSupplier, supplier);
	}
	
	@Override
	public T get() {
		Integer siteId = siteIdSupplier.get();
		AssertUtil.assertSupport(siteId!=null,"siteId不能为空");
		if(holds.get(siteId)==null){
			holds.put(siteId, supplier.get());
		}
		return holds.get(siteId);
	}
	
}
