package com.mini.framework.util.cache;

import java.util.Date;
import java.util.List;

/**
 *
 * @author jayheo 时序缓存器
 */
public interface TimeQueueCache {

	/**
	 * 向队列中写数据
	 * @param delay
	 * @param data
	 * @return
	 */
	TimeQueueCache write(Date delay, String data);

	/**
	 * 从队列中读数据，读完就扔了
	 * @param datePoint 时间极限，返回的结果应该大于这个极限。
	 * @return
	 */
	List<String> readBefore(Date datePoint);

	/**
	 * 从队列中读数据，读完就扔了，读当前时间的数据
	 * @return
	 */
	default List<String> readBefore() {
		return readBefore(new Date());
	}

}
