package com.mini.framework.util.cache.redis;

import com.mini.framework.util.log.trace.MapStorager;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author jayheo
 */
public class SpringRedisMapStorage implements MapStorager {

    private String storeKey;

    HashOperations<String, String, String> operation;



    @Override
    public void set(Map<String, String> map) {
        operation.putAll(storeKey, map);
    }

    @Override
    public Map<String, String> get() {
        return operation.entries(storeKey);
    }

    public SpringRedisMapStorage() {
    }

    public SpringRedisMapStorage(String storeKey,RedisTemplate<String, Map<String, String>> redisTemplate) {
        this.operation = redisTemplate.opsForHash();
        this.storeKey = storeKey;
    }


    public SpringRedisMapStorage(String storeKey,HashOperations<String, String, String> operation) {
        this.operation = operation;
        this.storeKey = storeKey;
    }

    public HashOperations<String, String, String> getOperation() {
        return operation;
    }

    public void setOperation(HashOperations<String, String, String> operation) {
        this.operation = operation;
    }

    public String getStoreKey() {
        return storeKey;
    }

    public void setStoreKey(String storeKey) {
        this.storeKey = storeKey;
    }
}
