package com.mini.framework.util.date;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 时间段类型
 * 
 * @author jayheo
 *
 */
public enum TimeSectionType implements  Comparator<TimeSectionType>{
	/**
	 * 小时
	 */
	hour, 
	/**
	 *自然日 
	 */
	day, 
	/**
	 * 自然周，目前是以周一为起点
	 */
	week, 
	/**
	 * 自然月
	 */
	month,
	/**
	 * 自然季
	 */
	season,
	/**
	 * 自然年
	 */
	year,
	/**
	 * 表示有史以来 
	 */
	all;
	
	
	
	private static Map<TimeSectionType, Integer> typeIndex = createTypeIndex();
	

	@Override
	public int compare(TimeSectionType o1, TimeSectionType o2) {
		return typeIndex.get(o1).compareTo(typeIndex.get(o2));
	}
	
	/**
	 * 从当前以的TimeSectionType 包含当前
	 * @return
	 */
	public List<TimeSectionType> typesFormThis(){
		return typeIndex.keySet().stream().filter(type->type.compareTo(this)>=0).collect(Collectors.toList());
	}

	private static Map<TimeSectionType, Integer> createTypeIndex() {
		Map<TimeSectionType, Integer> typeIndex = new ConcurrentHashMap<>();
		typeIndex.put(hour, 1);
		typeIndex.put(day, 2);
		typeIndex.put(week, 3);
		typeIndex.put(month, 4);
		typeIndex.put(season, 5);
		typeIndex.put(year, 6);
		typeIndex.put(all, 7);
		return typeIndex;
	}
}
