package com.mini.framework.util.export.protocol.branch;

import com.mini.framework.core.code.standard.style01.flag.define.CodeStandardDefineFind;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 分支替换
 * @author jayheo
 */
public @interface BooleanSwitchCase {

    /**
     * 匹配true的结果
     * @return
     */
    String trueResult();

    /**
     * 匹配false的结果
     * @return
     */
    String falseResult();



    /**
     * 匹配null的结果
     */
    String nullResult() default "";


    /**
     * 一个静态的支持类
     */
    static interface Support{


        /**
         * 应用使用boolean值
         * @param switchCase
         * @param stateOptional
         * @return
         */
        static String applyBooleanCase(BooleanSwitchCase switchCase, Optional<Boolean> stateOptional){
            return stateOptional.map(state->state?switchCase.trueResult():switchCase.falseResult()).orElse(switchCase.nullResult());
        }

        /**
         * 应用case
         * @param switchCase
         * @param origin
         * @return
         */
        static String applyCase(BooleanSwitchCase switchCase, String origin){
            return findCaseResult(switchCase, origin)
                    .orElse(origin);
        }


        /**
         * 查找匹配的值。如果不匹配返回 empty
         * @param switchCase
         * @param origin
         * @return
         */
        static Optional<String> findCaseResult(BooleanSwitchCase switchCase, String origin) {
            String value = applyBooleanCase(switchCase,findMatchCaseBoolean(switchCase, origin));
            return Optional.ofNullable(value);
        }


        /**
         * 找到符合的案例 布而值
         * @param switchCase
         * @return
         */
        @CodeStandardDefineFind
        static Optional<Boolean> findMatchCaseBoolean(BooleanSwitchCase switchCase, String origin){
            return Stream.of("true","false")
                    .filter(value->origin!=null)
                    .filter(value->value.equals(origin))
                    .map(Boolean::valueOf)
                    .findFirst();
        }

    }

}
