package com.mini.framework.util.function;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

/**
 * 执行判断器
 * @author jayheo
 *
 */
public interface Judge {

	/**
	 * 判断某个操作要不要执行
	 * @param explain 判断依据。
	 * @param target 操作的对象
	 * @param operator 具体的操作
	 * @return
	 */
	public static <T> T operator(T target,boolean explain,  UnaryOperator<T> operator) {
		return explain ? operator.apply(target) : target;
	}
	/**
	 * 确认有提供某个属性，如果没有提供就创建一个
	 * @param target
	 * @param showElement
	 * @param setElement
	 * @param createNewElement
	 * @return
	 */
	public static <T,E> Optional<E> surePresentByFill(T target,Function<T, E> showElement,BiConsumer<T, E> setElement,Supplier<E> createNewElement){
		if( showElement.apply(target)!=null){
			return Optional.empty();
		}else{
			E element = createNewElement.get();
			setElement.accept(target, element);
			return Optional.ofNullable(element);
		}
	}
	
	/**
	 * 选择第一个非空
	 * @param target1
	 * @param target2
	 * @param target3
	 * @param target4
	 * @return
	 */
	public static <T> T first(T target1, T target2,T target3,T target4){
		return first(first(target1, target2), target3, target4);
	}
	
	/**
	 * 选择第一个非空
	 * @param target1
	 * @param target2
	 * @param target3
	 * @return
	 */
	public static <T> T first(T target1, T target2,T target3){
		return first(first(target1, target2), target3);
	}

	/**
	 * 选择第一个非空
	 * @param target1
	 * @param target2
	 * @return
	 */
	public static <T> T first(T target1, T target2){
		BinaryOperator<T> first = first();
		return first.apply(target1, target2);
	}
	
	/**
	 * 得到选择第一个非空的方法
	 * @return
	 */
	public static <T> BinaryOperator<T> first(){
		return (target1,target2)->target1!=null?target1:target2;
	}
	
}
