package com.mini.framework.util.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Predicate;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.config.RequestConfig.Builder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;

public class HttpResStatusUtil {

	private static Logger logger = LogManager.getLogger(HttpResStatusUtil.class);
	
	
	private static RequestConfig createValiConfig(){
		Builder builder = RequestConfig.custom();
		builder.setConnectTimeout(1000);
		builder.setConnectionRequestTimeout(1000);
		builder.setSocketTimeout(1000);
		builder.setMaxRedirects(0);
		return builder.build();
	}
	
	public static Predicate<String> isExistMatch(){
		return url->isExist(url);
	}
	
	
	public static boolean isExist(String urlStr){
		return isExist(urlStr,1000);
	}
	
	
	//TODO 经过测试这个里超时默认是1秒种，需要优化一下，再提供超时的设置入口。
	//TODO 这里应该发header请求，以保证更小的数据流量和更高的效率。
	public static boolean isExist(String urlStr,int connectTimeout){
		if(StringUtils.isEmpty(urlStr)){
			return false;
		}
		AssertUtil.assertMethodRequire(urlStr, "urlStr");
		CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
		HttpGet httpGet = new HttpGet(urlStr);
		httpGet.setConfig(createValiConfig() );
		try(CloseableHttpResponse resp = closeableHttpClient.execute(httpGet)) {
			int status = resp.getStatusLine().getStatusCode();
			return status/100 == 2;
		} catch (IOException e) {
			logger.debug("尝试访问出错url:{}",urlStr,e);
			// ignore
			return false;
		}
	}
	
	
	
	public static byte[] readResUrl(String resUrl) {
		AssertUtil.assertMethodRequire(resUrl, "resUrl");
		try{
			URL url = new URL(resUrl);
			HttpURLConnection connection = (HttpURLConnection) url.openConnection();
			connection.connect();
			InputStream inputStream = connection.getInputStream();
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			IOUtils.copy(inputStream, baos);
			return baos.toByteArray();
		}catch(MalformedURLException e){
			throw new BadReqException(e,"资源[%s]格式错误",resUrl);
		}catch(IOException e){
			throw new HandleIOException(e, "read resUrl error url:[%s]", resUrl);
		}
	}
	
	public static File readResUrlAsFile(String resUrl,String filePath){
		byte[] data = readResUrl(resUrl);
		try(FileOutputStream fos = new FileOutputStream(new File(filePath))) {
			IOUtils.write(data, fos );
			return new File(filePath);
		} catch (IOException e) {
			throw new HandleIOException(e, "把字节流写到文件出错resUrl:[%s]", resUrl);
		}
	}
	
	
	
	
	
	
	
	
}
