package com.mini.framework.util.optional;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
/**
 * 可能的 set Long
 * */
@Deprecated
public class OptionalSetLong extends OptionalSet<Long>{


    private static final OptionalSetLong createEmpty (){
        return new OptionalSetLong();
    }

    public static OptionalSetLong ofNullable(Collection<Long> collLong){
        return collLong==null? createEmpty() :of(collLong);
    }

    /**
     * 从集合中取出来
     * */
    public static OptionalSetLong of(Collection<Long> collLong){
        OptionalSetLong set = new OptionalSetLong();
        set.value = new LinkedHashSet<>();
        Objects.requireNonNull(collLong,"collLong不能为空").stream().map(t->set.add(t));
        return set;
    }

    public static OptionalSetLong ofNullable(Long... ts){
        return ts==null? createEmpty() :of(ts);
    }

    /**
     * 从数据中取出来
     * */
    public static OptionalSetLong of(Long... ts){
        return of(Stream.of(ts).collect(Collectors.toSet()));
    }


    public static OptionalSetLong ofNullable(String arr){
        return arr==null? createEmpty() :of(arr);
    }

    public static OptionalSetLong of(String arr){
        String[] Longs = arr.split(",");
        List<Long> list = Stream.of(arr.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return of(list);
    }

    public Optional<Set<Long>> out(){
        return out(false);
    }

    public Optional<Set<Long>> outNotZero(){
        return out(true);
    }

    public Optional<Set<Long>> out(boolean zeroAsNull){
        if(zeroAsNull && (value!=null&& value.isEmpty())){
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }


    @Override
    public String toString() {
        return out().toString();
    }

}
