package com.mini.framework.util.oss.bean.work.modify;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.oss.bean.OssImageProcessParams;
import com.mini.framework.util.oss.bean.work.type.ResizeSchemeType;

/**
 * 图片缩放 https://help.aliyun.com/document_detail/44688.html?spm=a2c4g.11186623.6.1237.98874ecdoqpnM1
 * 
 * @author jayheo
 *
 */
@Desc("图片缩放 https://help.aliyun.com/document_detail/44688.html?spm=a2c4g.11186623.6.1237.98874ecdoqpnM1")
public class LimitResizeModifyOssImageWork extends ModifyOssImageWork {


	@Desc("指定裁剪宽度 [0-图片宽度]")
	private Integer width;
	@Desc("指定裁剪高度 [0-图片高度]")
	private Integer height;
	
	@Desc("指定当目标缩略图大于原图时是否处理。值是 1 表示不处理；值是 0 表示处理。")
	private Integer limit;
	
	@Desc("当缩放模式选择为 pad（缩略填充）时，可以选择填充的颜色(默认是白色)参数的填写方式：采用 16 进制颜色码表示，如 00FF00（绿色）。")
	private String color;
	
	
	@Desc("指定目标缩略图的最长边。	1-4096")
	private Integer max;
	
	@Desc("指定目标缩略图的最短边。	1-4096")
	private Integer min;

	@Desc("指定缩略的模式")
	private ResizeSchemeType scheme;
	
	public Integer getWidth() {
		return width;
	}

	public void setWidth(Integer width) {
		this.width = width;
	}

	public Integer getHeight() {
		return height;
	}

	public void setHeight(Integer height) {
		this.height = height;
	}

	public Integer getLimit() {
		return limit;
	}

	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public Integer getMax() {
		return max;
	}

	public void setMax(Integer max) {
		this.max = max;
	}

	public Integer getMin() {
		return min;
	}

	public void setMin(Integer min) {
		this.min = min;
	}

	public ResizeSchemeType getScheme() {
		return scheme;
	}

	public void setScheme(ResizeSchemeType scheme) {
		this.scheme = scheme;
	}

	@Override
	public OssImageProcessParams mapperProcessParams(Function<String, String> sureSameBucket) {
		return new OssImageProcessParams(getOssAction()).paramWhIfVal(width, height)
				.paramIfVal("m", scheme==null?null:scheme.name())
				.paramIfVal("w", width)
				.paramIfVal("h", height)
				.paramIfVal("l", max)
				.paramIfVal("s", min)
				.paramIfVal("limit", limit)
				.paramIfVal("color", color)
				;
	}


	public static List<LimitResizeModifyOssImageWork> createExamples() {
		LimitResizeModifyOssImageWork example = new LimitResizeModifyOssImageWork();
		example.setWorkDesc("图片缩放空值的例子");
		List<LimitResizeModifyOssImageWork> examples = new ArrayList<>();
		examples.add(example);
		return examples ;
	}

}
