package com.mini.framework.util.oss.bean.work.type;

import java.util.Map;

import com.mini.framework.util.bean.desc.Desc;
import com.mini.framework.util.type.EnumTypeShower;

/**
 * https://help.aliyun.com/document_detail/44688.html?spm=a2c4g.11186623.6.1237.50bf5bbfw8d9Gr
 * @author jayheo
 *
 */
@Desc("压缩方案的枚举")
public enum ResizeSchemeType implements EnumTypeShower<ResizeSchemeType>{
	lfit("lfit","等比缩放","限制在指定w与h的矩形内的最大图片。"),
	mfit("mfit","等比缩放","延伸出指定w与h的矩形框外的最小图片。"),
	fill("fill","固定宽高","将延伸出指定w与h的矩形框外的最小图片进行居中裁剪。"),
	pad("pad","固定宽高","缩略填充。"),
	fixed("fixed","固定宽高","强制缩略。")
	;
	
	private String key;
	
	private String title;
	
	private String desc;

	public String key(String key) {
		return this.key;
	}

	public String title(String title) {
		return this.title ;
	}

	public String desc(String desc) {
		return this.desc;
	}

	private ResizeSchemeType(String key, String title, String desc) {
		this.key = key;
		this.title = title;
		this.desc = desc;
	}

	@Override
	public void fillFieldToMap(Map<String, Object> map) {
		map.put("key", key);
		map.put("title", title);
		map.put("desc", desc);
	}
	
	
	
}
