package com.mini.framework.util.report.statistics.protocol;


import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;

import java.util.Date;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 一个统计的结果
 * @author jayheo
 */
public interface OneStatisticsResult {


    /**
     * 请理循环引用
     */
    default void clearCircleRef(){
        showQueryProcess().ifPresent(ForkQueryProcess::closeResource);
    }


    /**
     * 清除多余的字段。
     */
    void clearRedundancyFields();

    /**
     * 显示过程
     * @return 查询过程
     */
    Optional<ForkQueryProcess> showQueryProcess();


    /**
     * 填充过程
     * @param process
     */
    void fillQueryProcess(ForkQueryProcess process);

    /**
     * 显示统计的结果
     * @return
     */
    Optional<StatisticsResultMeta> showResultMeta();


    /**
     * 填充结果的信息
     * @param resultMeta
     */
    void fillResultMeta(StatisticsResultMeta resultMeta);


    /**
     * 标记 限制的时间
     * @param limitDate
     */
    default void markResultMeta(Date limitDate){
        //TODO 要把时间描述性文字也列出来 例如以什么unit来处理要忽略的时间 当前已忽略的时间等
        fillResultMeta(new StatisticsResultMeta(limitDate));
    }


    /**
     * 合并地结果
     * @param other
     */
    default void mergeOtherResultMeta(OneStatisticsResult other){
        if(!showResultMeta().isPresent()){
            other.showResultMeta().ifPresent(this::fillResultMeta);
        }

        Stream.of(this,other)
                .map(OneStatisticsResult::showQueryProcess)
                .filter(Optional::isPresent)
                .map(Optional::get)
                .reduce(ForkQueryProcess::mergeOtherQuerySpots)
                .ifPresent(this::fillQueryProcess);
    }

}
