package com.mini.framework.util.report.statistics.ranking.bean;

import java.util.function.Function;

/**
 *  抽象 的 简单的 计数求和 排行元素
 */
public abstract class  SimpleCountAndSumRankingElement<E extends SimpleCountAndSumRankingElement<E>>
        extends RankingElementSummationAmount<E> {

    private Long count;
    private Long sum;


    @Override
    protected void mergeOtherHandleImplElement(SimpleCountAndSumRankingElement other) {
        count+=other.count;
        sum+=other.sum;
    }

    @Override
    public <E extends Throwable> void validateOriginComplete(Function<String, E> exceptionSupplier) throws E {
        if (count==null){
            throw exceptionSupplier.apply("count不能为空");
        }
        if (sum==null){
            throw exceptionSupplier.apply("sum不能为空");
        }
    }

    public SimpleCountAndSumRankingElement(String countKey, Long count, Long sum) {
        super(countKey,null);
        this.count = count;
        this.sum = sum;
    }

    public SimpleCountAndSumRankingElement() {
        super();
    }

    public Long getCount() {
        return count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getSum() {
        return sum;
    }

    public void setSum(Long sum) {
        this.sum = sum;
    }
}
