package com.mini.framework.util.report.statistics.ranking.bean;

import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.function.Function;

/**
 *  抽象 的 简单的 计数求和 排行元素
 */
public class SimpleCountThenSumRankingElement extends SimpleCountAndSumRankingElement<SimpleCountThenSumRankingElement> {

    @Override
    public double countSorterScore() {
        //TODO 优先count再sum
        return (1.0 * getCount()) * Integer.MAX_VALUE + getSum();
    }


    public SimpleCountThenSumRankingElement() {}

    @Override
    protected StatisticsRankingTable<SimpleCountThenSumRankingElement> deserializeJsonRankingTable(String paramsJson) {
        Type type = new TypeToken<StatisticsRankingTable<SimpleCountThenSumRankingElement>>() {
        }.getType();
        return createGsonBuilder().create().fromJson(paramsJson,type);
    }

    public SimpleCountThenSumRankingElement(String countKey, Long count, Long sum) {
        super(countKey,count,sum);
    }
}
