package com.mini.framework.util.report.statistics.summation;

import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.report.statistics.Statistics;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.protocol.process.ProcessContext;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionChildrenRegionSummationLine;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.array.MultiParamsNativeRegionSummationArray;
import com.mini.framework.util.report.statistics.summation.bean.array.NativeRegionArraySummationArray;
import com.mini.framework.util.report.statistics.summation.bean.compare.BothSameRoundSummationCompare;
import com.mini.framework.util.report.statistics.summation.bean.compare.BothSummationCompare;
import com.mini.framework.util.report.statistics.summation.bean.compare.NativeRegionChildrenRegionSummationLineCompare;

import java.util.Date;
import java.util.List;
import java.util.Optional;


/**
 * 求和的统计
 * @param <P>
 */
public interface SummationStatistics<P extends StatisticsSerializeParams> extends Statistics {



    /**
     * 统计某个自然时间的求和
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    NativeRegionSummationElementAmount statisticsNativeDateSummation(
            ProcessContext context,P params, TimeRegionRange regionRange, Date queryLimitDate);


    /**
     * 统计多个参数某个自然时间的求和
     * @param context 查询过程的上下文
     * @param paramsList 用于过滤数据源的参数   的列表
     * @param regionRange 一个自然时间区间
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    MultiParamsNativeRegionSummationArray<P> statisticsMultiParamsNativeDateSummation(
            ProcessContext context, List<P> paramsList, TimeRegionRange regionRange, Date queryLimitDate);

    /**
     * TODO 要添加同比和环比
     * 统计某个自然时间的求和，并提供对比
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param queryLimitDate   历史时间的上限，也就是多久以前的时间是历史数据
     * @param compareIndexOffset
     * @return
     */
    BothSummationCompare statisticsNativeDateSummationWithBothCompare(
            ProcessContext context,P params, TimeRegionRange regionRange, Date queryLimitDate, int compareIndexOffset);


    /**
     * 统计某个自然时间的求和，并提供对比(同比和环比)
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @param roundCompareIndexOffset 环比的比较相对位置，-1表示上一个，-2表示上上一个依次类推，例如今天对比昨天，这里使用-1，对比明天使用 1
     * @param sameCompareIndexOffset  同比的比较相对位置，-1表示上一个周期的同期，-2表示上上一个周期的同期，例如今天(周二)对比上周二，这里使用-1，今天(周二)对比上上周二这里使用 -2
     * @param sameCompareUnitOptional 同比的范围，对于  日 有周同比月同比，那么这里就要选择了，对于年是没有同比的，那么这里为empty
     * @return
     */
    BothSameRoundSummationCompare statisticsNativeDateSummationWithSameRoundCompare(
            ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate
            , int roundCompareIndexOffset, int sameCompareIndexOffset, Optional<TimeRegionUnit> sameCompareUnitOptional);


    /**
     * 统计某个自然时间的求和，并提供对比(同比和环比) 与上一个时间单位对比
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param queryLimitDate  历史时间的上限，也就是多久以前的时间是历史数据
     * @param sameCompareUnitOptional  同比的范围，对于  日 有周同比月同比，那么这里就要选择了，对于年是没有同比的，那么这里为empty
     * @return
     */
    default BothSameRoundSummationCompare statisticsNativeDateSummationWithSameRoundCompare(
            ProcessContext context, P params, TimeRegionRange regionRange, Date queryLimitDate
            , Optional<TimeRegionUnit> sameCompareUnitOptional){
        return statisticsNativeDateSummationWithSameRoundCompare(context, params, regionRange, queryLimitDate,-1,-1, sameCompareUnitOptional);
    }


    /**
     * 统计多个连续的自然时间的求和
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionUnit
     * @param scopeRange 时间范围。(左闭右开)
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    SummationElementAmount statisticsNativeDateArraySummation(
            ProcessContext context, P params, TimeRegionUnit regionUnit, DateRange scopeRange, Date queryLimitDate);


    /**
     * 统计自定义(指定的)时间范围的求和
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param scopeRange 时间范围。(左闭右开)
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    SummationElementAmount statisticsCustomDateRangeSummation(ProcessContext context,P params, DateRange scopeRange, Date queryLimitDate);



    /**
     * 统计多个连续自然时间的分别求和得到列表
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionUnit
     * @param scopeRange 时间范围。(左闭右开)
     * @param queryLimitDate 历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    NativeRegionArraySummationArray statisticsNativeDateArrayScatterSummation(
            ProcessContext context, P params, TimeRegionUnit regionUnit, DateRange scopeRange, Date queryLimitDate);


    /**
     * 统计某个自然时间内分子时间单元的各个小区间的求和组成的列表。
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param childrenRegionUnit
     * @param queryLimitDate   历史时间的上限，也就是多久以前的时间是历史数据
     * @return
     */
    NativeRegionChildrenRegionSummationLine statisticsNativeDateChildrenArraySummationLine(
            ProcessContext context,P params, TimeRegionRange regionRange, TimeRegionUnit childrenRegionUnit, Date queryLimitDate);

    /**
     * 统计多个连续的自然时间的分别求和组成的列表 并对比其它曲线
     * TODO 还可以衍生出累计数据。例如 分布数据 12345 可以衍生出  1 3 6 10 15 的累计数据。
     * @param context 查询过程的上下文
     * @param params 用于过滤数据源的参数
     * @param regionRange 一个自然时间区间
     * @param childrenRegionUnit
     * @param queryLimitDate    历史时间的上限，也就是多久以前的时间是历史数据
     * @param compareIndexOffsets
     * @return
     */
    NativeRegionChildrenRegionSummationLineCompare statisticsNativeDateChildrenArraySummationLineWithCompare(
            ProcessContext context, P params, TimeRegionRange regionRange, TimeRegionUnit childrenRegionUnit, Date queryLimitDate, int[] compareIndexOffsets);
}
