package com.mini.framework.util.report.statistics.summation.bean;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.report.statistics.protocol.DivideDenominatorNumeratorSummation;
import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * TODO 还可以衍生出累计数据。例如 分布数据 12345 可以衍生出  1 3 6 10 15 的累计数据。
 * 在某个自然时间范围内的子范围的分布点的统计线。
 * 例如一天里的24个小时  一周里的 7天等
 * @author jayheo
 */
public class NativeRegionChildrenRegionSummationLine implements OneStatisticsResult, DivideDenominatorNumeratorSummation<NativeRegionChildrenRegionSummationLine> {
    
    
    private StatisticsResultMeta resultMeta;
    
    private ForkQueryProcess process;
    

    //TODO 在需要的时间添加累加的功能。

    /**
     * 大范围的开始时间
     */
    private Date scopeOffset;


    /**
     * 大范围的时间类型
     */
    private TimeRegionUnit scopeUnit;

    /**
     * 小统计点的时间类型
     */
    private TimeRegionUnit regionUnit;

    /**
     * 这条线的长度
     */
    private Integer lineLength;

    /**
     * 各个统计点组成的集合
     */
    private List<NativeRegionSummationElementAmount> summations;

    private List<NativeRegionSummationElementAmount> summationAccumulates;

    /**
     * 横坐标的名字
     */
    private List<String> coordinates;

    public static NativeRegionChildrenRegionSummationLine create(Date scopeOffset,TimeRegionUnit scopeUnit, TimeRegionUnit regionUnit, List<NativeRegionSummationElementAmount> summations){
        NativeRegionChildrenRegionSummationLine instance = new NativeRegionChildrenRegionSummationLine();
        instance.scopeOffset = scopeOffset;
        instance.scopeUnit = scopeUnit;
        instance.regionUnit = regionUnit;
        instance.summations = summations;
        instance.lineLength = summations.size();
        return instance;
    }

    /**
     * 除以另外一个数
     * @param expand
     * @param numeratorSum
     * @param denominatorSum
     * @param other
     */
    @Override
    public void mapperAmountDivideByOther(long expand, boolean numeratorSum, boolean denominatorSum, NativeRegionChildrenRegionSummationLine other){
        AssertUtil.assertNotFatalBug(summations.size()==other.summations.size()
                ,"summations.size():[%s]与other.summations.size():[%s]不一致",summations.size(),other.summations.size());
        this.mergeOtherResultMeta(other);
        for (int summationIndex = 0; summationIndex < summations.size(); summationIndex++) {
            summations.get(summationIndex).mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.summations.get(summationIndex));
        }

        if(summationAccumulates!=null && other.summationAccumulates!=null){
            AssertUtil.assertNotFatalBug(summationAccumulates.size()==other.summationAccumulates.size()
                    ,"summationAccumulates.size():[%s]与other.summationAccumulates.size():[%s]不一致",summationAccumulates.size(),other.summationAccumulates.size());
            for (int summationIndex = 0; summationIndex < summationAccumulates.size(); summationIndex++) {
                summationAccumulates.get(summationIndex).mapperAmountDivideByOther(expand,numeratorSum,denominatorSum,other.summationAccumulates.get(summationIndex));
            }
        }
    }


    /**
     * 计算累计量
     * @return
     */
    public NativeRegionChildrenRegionSummationLine fillArraySequenceAccumulates(){
        summationAccumulates = new ArrayList<>();
        summations.forEach(element-> {
            NativeRegionSummationElementAmount accumulate = element.copy();
            summationAccumulates.stream()
                    .reduce((prev,next)->next)
                    .ifPresent(accumulate::mergeOtherAmount);
            summationAccumulates.add(accumulate);
        });
        return this;
    }


    public TimeRegionUnit getRegionUnit() {
        return regionUnit;
    }

    public NativeRegionChildrenRegionSummationLine setRegionUnit(TimeRegionUnit regionUnit) {
        this.regionUnit = regionUnit;
        return this;
    }

    public Integer getLineLength() {
        return lineLength;
    }

    public NativeRegionChildrenRegionSummationLine setLineLength(Integer lineLength) {
        this.lineLength = lineLength;
        return this;
    }

    public TimeRegionUnit getScopeUnit() {
        return scopeUnit;
    }

    public NativeRegionChildrenRegionSummationLine setScopeUnit(TimeRegionUnit scopeUnit) {
        this.scopeUnit = scopeUnit;
        return this;
    }


    public List<String> getCoordinates() {
        return coordinates;
    }

    public NativeRegionChildrenRegionSummationLine setCoordinates(List<String> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    public Date getScopeOffset() {
        return scopeOffset;
    }

    public void setScopeOffset(Date scopeOffset) {
        this.scopeOffset = scopeOffset;
    }

    public List<NativeRegionSummationElementAmount> getSummations() {
        return summations;
    }

    public void setSummations(List<NativeRegionSummationElementAmount> summations) {
        this.summations = summations;
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public List<NativeRegionSummationElementAmount> getSummationAccumulates() {
        return summationAccumulates;
    }

    public void setSummationAccumulates(List<NativeRegionSummationElementAmount> summationAccumulates) {
        this.summationAccumulates = summationAccumulates;
    }


    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }


    @Override
    public void clearRedundancyFields() {
        Stream.of(summations,summationAccumulates).filter(Objects::nonNull).flatMap(List::stream)
                .forEach(OneStatisticsResult::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }
}
