package com.mini.framework.util.report.statistics.summation.bean.array;

import com.mini.framework.util.report.statistics.protocol.OneStatisticsResult;
import com.mini.framework.util.report.statistics.protocol.StatisticsResultMeta;
import com.mini.framework.util.report.statistics.protocol.StatisticsSerializeParams;
import com.mini.framework.util.report.statistics.protocol.process.ForkQueryProcess;
import com.mini.framework.util.report.statistics.summation.bean.NativeRegionSummationElementAmount;
import com.mini.framework.util.report.statistics.summation.bean.SummationElementAmount;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;


/**
 * 多个参数的自然时间区间和求和序列
 * @param <P>
 */
public class MultiParamsNativeRegionSummationArray<P extends StatisticsSerializeParams> implements OneStatisticsResult {


    private StatisticsResultMeta resultMeta;

    private ForkQueryProcess process;


    /**
     * 所有的求和的再求和
     */
    private SummationElementAmount allSummation = SummationElementAmount.createZeroEmpty();

    /**
     * 每个求和参数结果对
     */
    private List<StatisticsEntry<P>> elements = new ArrayList<>();


    public MultiParamsNativeRegionSummationArray<P> add(StatisticsEntry<P> entry){
        elements.add(entry);
        statisticsAllElement();
        return this;
    }
    public MultiParamsNativeRegionSummationArray<P> add(P params,NativeRegionSummationElementAmount summation){
        return add(new StatisticsEntry<>(params,summation));
    }

    public MultiParamsNativeRegionSummationArray<P> statisticsAllElement(){
        allSummation = elements.stream().map(StatisticsEntry::getSummation)
                .map(sa->(SummationElementAmount)sa)
                .reduce(SummationElementAmount.createZeroEmpty(),SummationElementAmount::mergeAmount);
        return this;
    }


    @Override
    public void fillResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    @Override
    public Optional<StatisticsResultMeta> showResultMeta() {
        return Optional.ofNullable(resultMeta);
    }

    /**
     * 倒序，以sum为依据
     * @param thenCount 是不是要把count作为第二依据
     * @return 返回它本身
     */
    public MultiParamsNativeRegionSummationArray<P> sortDescBySum(boolean thenCount){
        Collections.sort(elements,Comparator.comparing(StatisticsEntry::getSummation ,SummationElementAmount.sorterBySum(thenCount)));
        Collections.reverse(elements);
        return this;
    }


    /**
     * 倒序，以count为依据
     * @param thenSum 是不是要把sum作为第二依据
     * @return 返回它本身
     */
    public MultiParamsNativeRegionSummationArray<P> sortDescByCount(boolean thenSum){
        Collections.sort(elements,Comparator.comparing(StatisticsEntry::getSummation ,SummationElementAmount.sorterByCount(thenSum)));
        Collections.reverse(elements);
        return this;
    }

    public SummationElementAmount getAllSummation() {
        return allSummation;
    }

    public void setAllSummation(SummationElementAmount allSummation) {
        this.allSummation = allSummation;
    }

    public List<StatisticsEntry<P>> getElements() {
        return elements;
    }

    public void setElements(List<StatisticsEntry<P>> elements) {
        this.elements = elements;
    }

    public StatisticsResultMeta getResultMeta() {
        return resultMeta;
    }

    public void setResultMeta(StatisticsResultMeta resultMeta) {
        this.resultMeta = resultMeta;
    }

    public ForkQueryProcess getProcess() {
        return process;
    }

    public void setProcess(ForkQueryProcess process) {
        this.process = process;
    }

    @Override
    public void clearRedundancyFields() {
        elements.forEach(StatisticsEntry::clearRedundancyFields);
    }

    @Override
    public Optional<ForkQueryProcess> showQueryProcess() {
        return Optional.ofNullable(process);
    }

    @Override
    public void fillQueryProcess(ForkQueryProcess process) {
        this.process = process;
    }

    public static class StatisticsEntry<EP extends StatisticsSerializeParams>{

        private EP params;
        private NativeRegionSummationElementAmount summation;


        public void clearRedundancyFields(){
            summation.clearRedundancyFields();
        }

        public StatisticsEntry() {
        }

        public StatisticsEntry(EP params, NativeRegionSummationElementAmount summation) {
            this.params = params;
            this.summation = summation;
        }

        public EP getParams() {
            return params;
        }

        public void setParams(EP params) {
            this.params = params;
        }

        public NativeRegionSummationElementAmount getSummation() {
            return summation;
        }

        public void setSummation(NativeRegionSummationElementAmount summation) {
            this.summation = summation;
        }
    }

}
