package com.mini.framework.util.result;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.asserts.AssertUtil;

import java.util.function.Supplier;

/**
 * 有原因(一段描述性的话)的二分结果。
 * 什么是二分结果，即不是成功就是失败。
 * @author jayheo
 */
public class CauseBiResult {

    private static String emptySuccessCause = "缺少成功的理由";
    final private boolean success;

    /**
     * 原因
     * */
    final private String cause;


    private CauseBiResult(boolean success, String cause,Object... params) {
        AssertUtil.assertMethodRequire(cause,"cause");
        this.success = success;
        this.cause = String.format(cause,params);
    }

    public static CauseBiResult of(boolean success, String cause,Object... params) {
        return new CauseBiResult(success,cause,params);
    }

    public static CauseBiResult ofSuccess() {
        return ofSuccess(emptySuccessCause);
    }


    public static CauseBiResult ofSuccess( String cause,Object... params) {
        return of(true,cause,params);
    }

    public static CauseBiResult ofFailure( String cause,Object... params) {
        return of(false,cause,params);
    }



    /**
     * 是不是失败了。
     * */
    public boolean ifFailure(){
        return !ifSuccess();
    }

    /**
     * 是不是成功了。
     * */
    public boolean ifSuccess(){
        return success;
    };

    /**
     * 断言一定成功
     * */
    public <T extends CustomException> void assertSuccess(CustomExceptionSupplier exceptionSupplier)throws T{
        if(ifFailure()){
            throw exceptionSupplier.supply(getCause());
        }
    }


    public String getCause() {
        return cause;
    }

    /**
     * 不同状态的标题
     * */
    public String titleOfStatus(Supplier<String> successSupplier, Supplier<String> failureSupplier){
        return titleOfStatus(successSupplier.get(),failureSupplier.get());
    }

    /**
     * 不同状态的标题
     * */
    public String titleOfStatus(String success,String failure){
        return ifSuccess()?success:failure;
    }


    /**
     * 显示信息摘要
     * */
    public String summaryMessage(){
        return String.format("success?%s,状态为:%s,cause:%s",success, titleOfStatus("成功","失败"),cause);
    }



    @Override
    public String toString() {
        return String.format("success?%s,title:%s,cause:%s",success, titleOfStatus("成功","失败"),cause);
    }
}
