package com.mini.framework.util.sql.view.bean;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * 列的定义
 * @author jayheo
 */
public class ColumnDefine extends SqlViewBean {

   /**
    * 关联的key
    */
   private String key;

   /**
    * 列的名字
    */
   private String label;

   /**
    * 问号帮助文档的key
    */
   private String noteKey;

   /**
    * 出现空的时候的文本
    */
   private String emptyText;

   /**
    * 值类型
    */
   private ObjectStringValueType valueType;


   /**
    * 宽度的权重
    * 每个列有宽度是根据当前列在所有列中占的权重与表宽来决定的
    * 至于表宽是多少，根据容器来。
    */
   private Double widthWeight;


   /**
    * 依附到另外一个列中去
    * 这里记录的是被依附的key
    */
   private String dependOtherColumn;


   //TODO 后续要加上加过滤器功能。比如值 是 "234" 显示 "id:234"

   public <E extends CustomException> ColumnDefine validateComplete(CustomExceptionSupplier<E> exceptionSupplier)throws E{
      exceptionSupplier.applyAssert(key!=null,"列key不能为空");
      exceptionSupplier.applyAssert(label!=null,"列label不能为空");
      exceptionSupplier.applyAssert(valueType!=null,"列valueType不能为空");
      return this;
   }


   public String getKey() {
      return key;
   }

   public ColumnDefine setKey(String key) {
      this.key = key;
      return this;
   }

   public String getLabel() {
      return label;
   }

   public ColumnDefine setLabel(String label) {
      this.label = label;
      return this;
   }

   public String getNoteKey() {
      return noteKey;
   }

   public ColumnDefine setNoteKey(String noteKey) {
      this.noteKey = noteKey;
      return this;
   }

   public String getEmptyText() {
      return emptyText;
   }

   public ColumnDefine setEmptyText(String emptyText) {
      this.emptyText = emptyText;
      return this;
   }

   public ObjectStringValueType getValueType() {
      return valueType;
   }

   public ColumnDefine setValueType(ObjectStringValueType valueType) {
      this.valueType = valueType;
      return this;
   }

   public Double getWidthWeight() {
      return widthWeight;
   }

   public ColumnDefine setWidthWeight(Double widthWeight) {
      this.widthWeight = widthWeight;
      return this;
   }

   public String getDependOtherColumn() {
      return dependOtherColumn;
   }

   public ColumnDefine setDependOtherColumn(String dependOtherColumn) {
      this.dependOtherColumn = dependOtherColumn;
      return this;
   }
}
