package com.mini.framework.util.sql.view.bean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 在数据库中查到原始数据的行
 * @author jayheo
 */
public class RowOrigin extends SqlViewBean {

    private List<ColumnOrigin> columns;


    private Object origin;

    public List<ColumnOrigin> getColumns() {
        return columns;
    }

    public RowOrigin setColumns(List<ColumnOrigin> columns) {
        this.columns = columns;
        return this;
    }


    public static <T> RowOrigin from(Map<String,T> mapper){
        //TODO 返回数据的顺序需要处理一下。
        return from(new LinkedHashMap<>(mapper));
    }

    public static <T> RowOrigin from(LinkedHashMap<String,T> mapper){

        RowOrigin instance = new RowOrigin();
        instance.origin = mapper;
        instance.columns = mapper.entrySet().stream().map(ColumnOrigin::from).collect(Collectors.toList());
        return instance;
    }
}
