package com.mini.framework.util.store;

import com.mini.framework.util.store.bean.StringKeyValuePairBean;

import java.util.Optional;


/**
 * string 型的 key value 存储器
 */
public class StringKeyValueMemoryStorage extends MemoryTableStorage<StringKeyValuePairBean> {

    public void coverSave(String key,String value) {
        super.coverSave(new StringKeyValuePairBean(key,value));
    }

    public Optional<String> queryValueByKey(String key){
        return queryOnlyOneByKey(key).map(StringKeyValuePairBean::getValue);
    }

}
