package com.mini.framework.util.string;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.asserts.AssertUtil;

public class StringUtil {
	
	private static String utf8= "utf-8";
	
	public static byte[] getUtf8Byte(String str) {
		try {
			return str.getBytes("utf-8");
		} catch (UnsupportedEncodingException e) {
			throw new HandleEnDeCodeException(e, "把[%s]得到utf-8编码时错误", str);
		}
	}

	
	public static String toUtf8String(byte[] bytes) {
		try {
			return new String(bytes,"utf-8");
		} catch (UnsupportedEncodingException e) {
			throw new HandleEnDeCodeException(e, "把[%s]用utf-8编码成字符串时错误", bytes);
		}
	}
	
	/**
	 * 把字节转成字符，然后再拼成字符串
	 * @param bytes
	 * @return
	 */
/*	@Deprecated
	public static String bytesAsCharsToString(byte[] bytes){
		return new String(ByteUtil.bytesToChars(bytes));
	}*/
	
	/**
	 * 把字符串数据转成bytes
	 * @param string
	 * @return
	 */
/*	@Deprecated
	public static Optional<byte[]> stringCharsToBytes(String string){
		return ByteUtil.charsToBytes(string.toCharArray());
	}*/


	/**
	 * 把long型的分钱转成元钱单位的钱数，需要自己加单位
	 * @param fen
	 * @return
	 */
	public static String fen2yuan(long fen){
		return fen/100 + "." + StringUtils.leftPad(String.valueOf(fen%100), 2, "0");
	}
	
	/**
	 * 把int型的分钱转成元钱单位的钱数，需要自己加单位
	 * @param fen
	 * @return
	 */
	public static String fen2yuan(int fen){
		return fen/100 + "." + StringUtils.leftPad(String.valueOf(fen%100), 2, "0");
	}
	
	public static Optional<Integer> yuan2fen(String yuan){
		AssertUtil.assertMethodRequire(yuan, "yuan");
		if(yuan.startsWith(".")){
			yuan = "0" + yuan;
		}
		String[] items = StringUtils.split(yuan, ".");
		String first = items[0];
		if(items.length==1){
			if(StringUtils.isNumeric(first)){
				if(first.length()>0){
					return Optional.of(Integer.parseInt(first)*100);
				}
			}
		}else if(items.length==2){
			String second = items[1];
			Integer secondMoney = 0;
			if(StringUtils.isNumeric(second) && second.length()<=2 && second.length()>0){
				secondMoney = Integer.parseInt(second);
			}else{
				return Optional.empty();
			}
			
			if(first.length()>0){
				return Optional.of(Integer.parseInt(first)*100 + secondMoney);
			}else if(first.length()==0){
				return Optional.of(secondMoney);
			}
		}
		return Optional.empty();
	}
	
	
	public static String urlEncode(String url){
		try {
			return URLEncoder.encode(url, utf8);
		} catch (UnsupportedEncodingException e) {
			throw new HandleEnDeCodeException(e, "把[%s]用urlEncode编码时错误", url);
		}
	}
	
	public static String urlDecode(String url){
		try {
			return URLDecoder.decode(url, utf8);
		} catch (UnsupportedEncodingException e) {
			throw new HandleEnDeCodeException(e, "把[%s]用urlDecode解码时错误", url);
		}
	}
	
	/**
	 * 根据符号以外的字符分隔
	 * @param keyword
	 * @return
	 */
	public static String[] splitByNotWords(String keyword){
		keyword = keyword.replaceAll( "[^a-zA-Z0-9\u4e00-\u9fa5]", " ");
		String[] keys = StringUtils.split(keyword, null);
		keys = Arrays.asList(keys).stream().filter(key->key!=null&&key.length()>0).distinct().collect(Collectors.toList()).toArray(keys);
		//TODO 要处理一下搜索条件，例如模糊搜索的时候，同时有   昵称和昵 两个词，其实昵称是没有义意的。
		//TODO 应该限制搜索条件的数据，太多了其实没有话意义。
		return keys;
	}
	
}
