package com.mini.framework.util.string.gson.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

import com.google.gson.Gson;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;

/**
 * json数据构建器
 * @author jayheo
 *
 */
public class GsonData extends LinkedHashMap<String, Object> {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 652494645287860116L;
	
	public static GsonData build() {
		return new GsonData();
	}
	/*
	private LinkedHashMap<String, Object> data;

	
	private LinkedHashMap<String, Object> currData(){
		if(data==null){
			synchronized (GsonData.class) {
				if(data==null){
					data = new LinkedHashMap<String, Object>();
				}
			}
		}
		return data;
	}*/
	
	private LinkedHashMap<String, Object> currData(){
		return this;
	}

	public GsonData param(String key, String value) {

		return param(key, (Object) value);
	}

	public GsonData param(String key, Object value) {
		currData().put(key, value);
		return this;
	}
	

	public GsonData array(String key, Consumer<List<GsonData>> arrayConsumer) {
		List<GsonData> array = new ArrayList<GsonData>();
		arrayConsumer.accept(array);
		return param(key, array);
	}

	public GsonData object(String key, Consumer<GsonData> objectConsumer) {
		GsonData object = build();
		objectConsumer.accept(object);
		return param(key, object.currData());
	}
	
	public String toJson(Gson gson){
		AssertUtil.assertMethodRequire(gson, "gson");
		return gson.toJson(currData() );
	}
	
	public String toJson(){
		return toJson(GsonUtil.buildMilliSecondDateGson());
	}

}
