package com.mini.framework.util.string.gson.format;

import com.mini.framework.core.code.standard.style01.flag.require.CodeStandardRequireProposeFramework;
import com.mini.framework.util.function.FinalUsefulCounter;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * 响应格式支持，这个注解允许用户把响应做一个格式化
 * 通过参数dataFormat去控制格式化的策略
 * 如果想要这个注解生效就要在项目中注入 ResponseFormatAnnotationSuppert 类
 * @author jayheo
 * 
 */
@Target({ElementType.METHOD,ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ResponseFormat {
	
	/**
	 * 格式化命令的别名。
	 * 可以0-n个别名
	 * @return
	 */
	FormatAlias[] value() default {};


	/**
	 * 工作方法。
	 * @return
	 */
	WorkScheme workScheme() default @WorkScheme();


	/**
	 * 当前的名字
	 * @return
	 */
	String name() default "todoResponseFormatUnknownName";

	interface Support{
		/**
		 * 根据工具策略，保留可用的列表
		 * @param origins
		 * @return
		 */
		static List<ResponseFormat> retainUsefulByWorkScheme(List<ResponseFormat> origins){
			FinalUsefulCounter skipFollowCounter = FinalUsefulCounter.create();
			Predicate<ResponseFormat> handleFollowPredicate = responseFormat -> {
				WorkScheme workScheme = responseFormat.workScheme();
				skipFollowCounter.add();
				return skipFollowCounter.ifNotHave();
			};

			Predicate<ResponseFormat> workOnlyPredicate = responseFormat -> responseFormat.workScheme().workAlone();


			List<ResponseFormat> skipOnlyMarkResult = origins.stream().filter(responseFormat -> !responseFormat.workScheme().notJoinFormat()).collect(Collectors.toList());


			List<ResponseFormat> skipFollowResult = skipOnlyMarkResult.stream()
					.filter(handleFollowPredicate)
					.collect(Collectors.toList());

			@CodeStandardRequireProposeFramework(title = "快速生成集合",suggest = {"做成工具类统一使用","要一次性把这个情况都考虑好"},cause = "代码太多了，工具需要简化")
			Function<ResponseFormat,List<ResponseFormat>> oneAsList = item->{
				List<ResponseFormat> list = new ArrayList<>();
				list.add(item);
				return list;
			};

			return skipFollowResult.stream()
					.filter(workOnlyPredicate)
					.findFirst()
					.map(oneAsList).orElse(skipFollowResult);

		}
	}
	
}
