/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.cache;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.bean.VarUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class HoldBiFunction<T, U, R>
implements BiFunction<T, U, R> {
    private Map<Map.Entry<T, U>, R> cacheMapper = new HashMap<Map.Entry<T, U>, R>();
    private List<Map.Entry<T, U>> executeFlag = new ArrayList<Map.Entry<T, U>>();
    private BiFunction<T, U, R> biFunction = null;

    private HoldBiFunction(BiFunction<T, U, R> biFunction) {
        this.biFunction = biFunction;
    }

    public static <T, U, R> HoldBiFunction<T, U, R> create(BiFunction<T, U, R> biFunction) {
        AssertUtil.assertMethodRequire(biFunction, "biFunction");
        return new HoldBiFunction<T, U, R>(biFunction);
    }

    @Override
    public R apply(T t, U u) {
        if (this.containFlagKey(t, u)) {
            return this.getFromCacheMapper(t, u).orElse(null);
        }
        this.addFlagKey(t, u);
        R r = this.biFunction.apply(t, u);
        this.cacheMapper.put(VarUtil.createEntry(t, u), r);
        return r;
    }

    private Optional<R> getFromCacheMapper(T t, U u) {
        this.entryMatch(t, u);
        return this.cacheMapper.entrySet().stream().filter(cache -> this.entryMatch(t, u).test((Map.Entry<Object, Object>)cache.getKey())).findFirst().map(Map.Entry::getValue);
    }

    private void addFlagKey(T t, U u) {
        this.executeFlag.add(VarUtil.createEntry(t, u));
    }

    private boolean containFlagKey(T t, U u) {
        return this.executeFlag.stream().anyMatch(this.entryMatch(t, u));
    }

    private Predicate<Map.Entry<T, U>> entryMatch(T t, U u) {
        return entry -> this.varSameStatus(entry.getKey(), t) && this.varSameStatus(entry.getValue(), u);
    }

    private <O> boolean varSameStatus(O t1, O t2) {
        return t1 == null && t2 == null || Objects.equals(t1, t2);
    }

    public void clear() {
        this.executeFlag.clear();
        this.cacheMapper.clear();
    }
}

