/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.increment;

import com.mini.framework.core.exception.HandleStoreException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.increment.IncrementGenerator;
import com.mini.framework.util.increment.IncrementStore;
import com.mini.framework.util.increment.IncrementStrategy;
import com.mini.framework.util.increment.SimpleIncrementStrategy;

public class IncrementUtil {
    private IncrementStrategy incrementStrategy;
    private IncrementGenerator incrementGenerator;
    private int conflictAddTime = 10;
    private String key;

    public IncrementUtil(String key, IncrementStrategy incrementStrategy, IncrementGenerator incrementGenerator) {
        this.incrementStrategy = incrementStrategy;
        this.incrementGenerator = incrementGenerator;
        this.key = key;
    }

    public int getConflictAddTime() {
        return this.conflictAddTime;
    }

    public void setConflictAddTime(int conflictAddTime) {
        this.conflictAddTime = conflictAddTime;
    }

    public void execute(IncrementStore incrementStore) {
        int step = this.incrementStrategy.stepIncrement();
        long increment = this.incrementGenerator.nextIncrement(this.key, step);
        try {
            incrementStore.storeIncrement(this.key, increment);
        }
        catch (HandleStoreException e) {
            if (e.statusCode() == Status.Handle.violateUnique.code()) {
                long maxStore = incrementStore.showMaxStore(this.key);
                for (int i = 0; i < this.conflictAddTime; ++i) {
                    maxStore += (long)this.incrementStrategy.stepIncrement();
                }
                this.incrementGenerator.resetIncrement(this.key, maxStore);
                increment = this.incrementGenerator.nextIncrement(this.key, step);
                incrementStore.storeIncrement(this.key, increment);
            }
            throw e;
        }
    }

    public static IncrementStrategy buildSimpleStrategy(int offset, int limit) {
        return new SimpleIncrementStrategy(offset, limit);
    }
}

