/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.qrcode;

import com.google.gson.Gson;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.util.asserts.AssertUtil;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QrcodeUtil {
    private Logger logger = LogManager.getLogger(QrcodeUtil.class);
    private static HashMap<EncodeHintType, Object> basicParams = QrcodeUtil.createParams();
    private static final String format = "png";
    private int width = 400;
    private int height = 400;
    private String charset = "UTF-8";

    public QrcodeUtil() {
    }

    public QrcodeUtil(int size) {
        this(size, size);
    }

    public QrcodeUtil(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public byte[] createBytes(String content) {
        AssertUtil.assertNotEmpty(content, "\u8f6c\u7ef4\u7801\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        MultiFormatWriter mfw = new MultiFormatWriter();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            BitMatrix bitMatrix = mfw.encode(content, BarcodeFormat.QR_CODE, this.width, this.height, basicParams);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)format, (OutputStream)stream);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (WriterException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u628a[%s]\u751f\u6210\u4e8c\u7ef4\u7801\u65f6\u51fa\u9519", new Object[]{content});
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u628a[%s]\u751f\u6210\u4e8c\u7ef4\u7801\u65f6\u51fa\u9519", new Object[]{content});
        }
        finally {
            IOUtils.closeQuietly((OutputStream)stream);
        }
    }

    public String tryDecode(byte[] picByte) {
        try {
            return this.decode(new ByteArrayInputStream(picByte));
        }
        catch (Throwable e) {
            this.logger.debug("\u5c1d\u8bd5\u89e3\u6790\u4e8c\u7ef4\u7801\u65f6\u5931\u8d25", e);
            return null;
        }
    }

    public String decode(byte[] picByte) {
        return this.decode(new ByteArrayInputStream(picByte));
    }

    public String decode(InputStream is) {
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
            HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)binarizer);
            HashMap<DecodeHintType, Object> decodeHints = new HashMap<DecodeHintType, Object>();
            decodeHints.put(DecodeHintType.POSSIBLE_FORMATS, Arrays.asList(BarcodeFormat.QR_CODE));
            decodeHints.put(DecodeHintType.CHARACTER_SET, this.charset);
            Result result = new MultiFormatReader().decode(bitmap, decodeHints);
            return result.getText();
        }
        catch (NotFoundException e) {
            throw new HandleEnDeCodeException("\u65e0\u6cd5\u8bc6\u522b\u4e8c\u7ef4\u7801", new Object[0]);
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u89e3\u6790\u4e8c\u7ef4\u7801\u65f6\u6d41\u51fa\u9519", new Object[0]);
        }
    }

    private static HashMap<EncodeHintType, Object> createParams() {
        HashMap<EncodeHintType, Object> params = new HashMap<EncodeHintType, Object>();
        params.put(EncodeHintType.CHARACTER_SET, "utf-8");
        params.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        params.put(EncodeHintType.MARGIN, 0);
        return params;
    }

    public byte[] createBytes(Object obj) {
        AssertUtil.assertNotNull(obj, "\u8f6c\u4e8c\u7ef4\u7801\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        String content = new Gson().toJson(obj);
        return this.createBytes(content);
    }

    public static void insertImage(BufferedImage source, String imgPath, int x, int y) throws MalformedURLException, IOException {
        BufferedImage src = ImageIO.read(new URL(imgPath));
        int width = ((Image)src).getWidth(null);
        int height = ((Image)src).getHeight(null);
        Graphics2D graph = source.createGraphics();
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, height, 10.0f, 10.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }

    public byte[] insertLogo(byte[] target, byte[] sourse, int sizeRaito) {
        try {
            BufferedImage targetBi = ImageIO.read(new ByteArrayInputStream(target));
            BufferedImage sourseBi = ImageIO.read(new ByteArrayInputStream(sourse));
            int width = targetBi.getWidth();
            int height = targetBi.getHeight();
            int widthSize = width * sizeRaito / 100;
            int widthBegin = (width - widthSize) / 2;
            int heightSize = height * sizeRaito / 100;
            int heightBegin = (height - heightSize) / 2;
            BufferedImage newImg = new BufferedImage(width, height, 5);
            int[] rgbArray = targetBi.getRGB(0, 0, width, height, null, 0, width);
            newImg.setRGB(0, 0, width, height, rgbArray, 0, width);
            int sourseWidth = sourseBi.getWidth();
            int sourseHeight = sourseBi.getHeight();
            for (int i = 0; i < widthSize; ++i) {
                for (int j = 0; j < heightSize; ++j) {
                    int rgb = sourseBi.getRGB(i * sourseWidth / widthSize, j * sourseHeight / heightSize);
                    newImg.setRGB(i + widthBegin, j + heightBegin, rgb);
                }
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream output = new MemoryCacheImageOutputStream(stream);
            ImageIO.write((RenderedImage)newImg, "jpg", output);
            return stream.toByteArray();
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u6dfb\u52a0logo\u5931\u8d25", new Object[]{sizeRaito});
        }
    }
}

