/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.reflect;

import com.mini.framework.core.exception.LogicException;
import com.mini.framework.util.asserts.AssertUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ReflectUtil {
    public static List<Field> getSimplePojoFieldFromClass(Class<?> clazz) {
        return ReflectUtil.getAllFieldFromClass(clazz).stream().filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !"serialVersionUID".equals(field.getName())).collect(Collectors.toList());
    }

    public static List<Field> getAllFieldFromClass(Class<?> clazz) {
        AssertUtil.assertMethodRequire(clazz, "clazz");
        ArrayList<Field> allField = new ArrayList<Field>();
        Class<?> tempClass = clazz;
        do {
            Field[] fields = tempClass.getDeclaredFields();
            allField.addAll(Arrays.asList(fields));
        } while ((tempClass = tempClass.getSuperclass()) != null && tempClass != Object.class);
        return allField;
    }

    public static boolean notExistClassByName(String className) {
        return !ReflectUtil.existClassByName(className);
    }

    public static boolean existClassByName(String className) {
        AssertUtil.assertMethodRequire(className, "className");
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean matchOneClassLoader(Object object1, Object object2) {
        AssertUtil.assertMethodRequire(object1, "object1");
        AssertUtil.assertMethodRequire(object2, "object2");
        int hashCode1 = ReflectUtil.findBelongClassLoader(object1).map(Objects::hashCode).orElse(1);
        int hashCode2 = ReflectUtil.findBelongClassLoader(object2).map(Objects::hashCode).orElse(2);
        return hashCode1 == hashCode2;
    }

    public static ClassLoader getBelongClassLoader(Object object) {
        return ReflectUtil.findBelongClassLoader(object).orElseThrow(() -> new LogicException("\u5728\u83b7\u53d6\u7c7b\u52a0\u8f7d\u5668\u7684\u65f6\u5019\u53d1\u73b0\u627e\u4e0d\u5230\u52a0\u8f7d\u5668 object.getClass():[%s]", new Object[]{object.getClass()}));
    }

    public static Optional<ClassLoader> findBelongClassLoader(Object object) {
        AssertUtil.assertMethodRequire(object, "object");
        return Optional.of(object).map(obj -> {
            if (object.getClass() == String.class) {
                return null;
            }
            if (object.getClass() == Class.class) {
                return ((Class)object).getClassLoader();
            }
            if (object.getClass() == Field.class) {
                return ((Field)object).getDeclaringClass().getClassLoader();
            }
            if (object.getClass() == Method.class) {
                return ((Method)object).getDeclaringClass().getClassLoader();
            }
            if (object.getClass().equals(Object.class)) {
                return null;
            }
            return object.getClass().getClassLoader();
        });
    }
}

