/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.protocol;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.object.SetUsefulObject;
import com.mini.framework.util.report.statistics.protocol.TimeRegionUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TimeRegionRange
extends SetUsefulObject<TimeRegionRange> {
    private TimeRegionUnit unit;
    private Date offset;
    private Date offsetAllUnit;
    private String offsetSimpleString;

    public static TimeRegionRange create(TimeRegionUnit unit, Date offset) {
        return TimeRegionRange.create(unit, offset, error -> new ServerException(Status.Server.programConfigJava, error, new Object[0]));
    }

    public static <E extends CustomException> TimeRegionRange create(TimeRegionUnit unit, Date offset, CustomExceptionSupplier<E> exceptionSupplier) throws E {
        TimeRegionRange instance = new TimeRegionRange();
        instance.unit = unit;
        instance.offset = offset;
        instance.validateOffsetRightPoint(exceptionSupplier);
        return instance.mapperShows();
    }

    public static TimeRegionRange createAllUnit(Date offsetAllUnit) {
        TimeRegionRange range = TimeRegionRange.create(TimeRegionUnit.all, new Date(0L));
        range.offsetAllUnit = offsetAllUnit;
        return range;
    }

    public long timeScopeCrossMilli() {
        return this.mapperToDate().getTime() - this.offset.getTime();
    }

    public TimeRegionRange mapperShows() {
        this.offsetSimpleString = DateUtil.toMilSecondsString(this.offset);
        return this;
    }

    public DateRange showDateRange() {
        if (this.unit.equalType(TimeRegionUnit.all)) {
            return DateRange.create(this.offsetAllUnit, TimeRegionUnit.year.addTimeUnit(this.offsetAllUnit, 100));
        }
        return DateRange.create(this.offset, this.mapperToDate());
    }

    public boolean same(TimeRegionRange other) {
        return this.offset.equals(other.offset) && this.unit.equals(other.unit);
    }

    public static Comparator<TimeRegionRange> randomSorter() {
        int primeNumber = 9973;
        return Comparator.comparing(range -> range.offset.getTime() * (long)range.hashCode() / (long)primeNumber);
    }

    public static Comparator<TimeRegionRange> offsetUpperSorter() {
        return Comparator.comparing(TimeRegionRange::getOffset);
    }

    public TimeRegionRange findSuperRegionRange(TimeRegionUnit superUnit) {
        this.unit.validateCanAccumulateTo(superUnit);
        return superUnit.nearFenceRange(this.offset);
    }

    public <E extends CustomException> TimeRegionRange validateOffsetRightPoint(CustomExceptionSupplier<E> exceptionSupplier) throws E {
        exceptionSupplier.applyAssert(this.offset != null, "offset\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        exceptionSupplier.applyAssert(this.unit != null, "unit\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Date rightPoint = this.unit.nearLazyFenceRangeDate(this.offset);
        exceptionSupplier.applyAssert(rightPoint.equals(this.offset), "range\u4e2dunit:[%s]\u5f53\u524doffset:[%s]\u4e0e\u6b63\u786e\u7684offset:[%s]\u4e0d\u4e00\u81f4", new Object[]{this.unit, this.offset.getTime(), rightPoint.getTime()});
        return this;
    }

    public Optional<List<TimeRegionRange>> mapperComposeElementFences() {
        return this.unit.getComposeElement().map(unit -> unit.regionFences(this.offset, this.mapperToDate()));
    }

    public Optional<TimeRegionRange> showComposeElement() {
        return this.mapperComposeElementFences().flatMap(list -> list.stream().findFirst());
    }

    public Date mapperToDate() {
        return this.unit.addTimeUnit(this.offset, 1);
    }

    public boolean matchUnit(TimeRegionUnit unit) {
        return this.unit.equals(unit);
    }

    public boolean match(TimeRegionRange other) {
        return this.matchUnit(other.unit) && this.offset.equals(other.offset);
    }

    public TimeRegionRange nextRegionRange(int amount) {
        return TimeRegionRange.create(this.unit, this.unit.addTimeUnit(this.offset, amount));
    }

    public TimeRegionRange nextRegionRange() {
        return this.nextRegionRange(1);
    }

    public TimeRegionRange previousRegionRange() {
        return this.nextRegionRange(-1);
    }

    public TimeRegionRange nextSameRegionRange(TimeRegionUnit superUnit, int amount) {
        this.unit.validateCanAccumulateTo(superUnit);
        Date superOffset = superUnit.nearLazyFenceRangeDate(this.offset);
        int itemIndex = this.unit.regionFences(superOffset, this.offset).size();
        Date otherSuperOffset = superUnit.addTimeUnit(superOffset, amount);
        Date otherSameDate = this.unit.addTimeUnit(otherSuperOffset, itemIndex);
        return TimeRegionRange.create(this.unit, otherSameDate);
    }

    public boolean matchSuperScope(TimeRegionRange superScope) {
        AssertUtil.assertMethodRequire(superScope, "superScope");
        this.unit.validateCanAccumulateTo(superScope.unit);
        return this.matchSuperScope(this.showDateRange());
    }

    public boolean matchSuperScope(DateRange superScope) {
        return !this.offset.before(superScope.getMinDate()) && !superScope.getMaxDate().before(this.mapperToDate());
    }

    public List<TimeRegionRange> splitRangeLessPoint(TimeRegionUnit minUnit, TimeRegionUnit maxUnit) {
        return TimeRegionRange.splitRangeLessPoint(this.showDateRange(), minUnit, maxUnit, CustomExceptionSupplier.fromFunction(message -> new ServerException("%s \u51fa\u73b0bug\u9700\u8981\u68c0\u67e5\u7a0b\u5e8f", new Object[]{message})));
    }

    public static List<TimeRegionRange> splitRangeLessPoint(DateRange scopeRange, TimeRegionUnit minUnit, TimeRegionUnit maxUnit, CustomExceptionSupplier exceptionSupplier) {
        return TimeRegionRange.splitRangeLessPointHandleChip(scopeRange, minUnit, maxUnit, restChip -> {
            throw exceptionSupplier.supply("\u65f6\u95f4\u533a\u95f4[%s,%s)\u627e\u4e0d\u5230\u7ec6\u5206\u81ea\u7136\u65f6\u95f4\u533a\u95f4", new Object[]{restChip.getMinDate().getTime(), restChip.getMinDate().getTime()});
        });
    }

    public static List<TimeRegionRange> splitRangeLessPointHandleChip(DateRange scopeRange, TimeRegionUnit minUnit, TimeRegionUnit maxUnit, Consumer<DateRange> onFoundRestChip) {
        if (scopeRange.haveTimeScope()) {
            Date rangeMinDate = scopeRange.getMinDate();
            Date rangeMaxDate = scopeRange.getMaxDate();
            Optional<TimeRegionRange> subRegionRangeOptional = TimeRegionUnit.showElementUsefulDownSort(minUnit, maxUnit).stream().map(unit -> TimeRegionRange.create(unit, unit.nearGreedyFenceRangeDate(rangeMinDate))).filter(range -> range.matchSuperScope(DateRange.create(rangeMinDate, rangeMaxDate))).findFirst();
            ArrayList<TimeRegionRange> allRange = new ArrayList<TimeRegionRange>();
            DateRange discardRange = subRegionRangeOptional.map(TimeRegionRange::showDateRange).orElse(scopeRange);
            List<TimeRegionRange> beforeRanges = TimeRegionRange.splitRangeLessPointHandleChip(DateRange.create(rangeMinDate, discardRange.getMinDate()), minUnit, maxUnit, onFoundRestChip);
            List<TimeRegionRange> afterRanges = TimeRegionRange.splitRangeLessPointHandleChip(DateRange.create(discardRange.getMaxDate(), rangeMaxDate), minUnit, maxUnit, onFoundRestChip);
            allRange.addAll(beforeRanges);
            subRegionRangeOptional.ifPresent(allRange::add);
            if (!subRegionRangeOptional.isPresent()) {
                onFoundRestChip.accept(scopeRange);
            }
            allRange.addAll(afterRanges);
            return allRange;
        }
        return new ArrayList<TimeRegionRange>();
    }

    public List<TimeRegionRange> findElementRegionFences(TimeRegionUnit elementUnit) {
        AssertUtil.assertMethodRequire(elementUnit, "elementUnit");
        elementUnit.validateCanAccumulateTo(this.unit);
        return this.unit.findElementRegionFences(TimeRegionRange.create(elementUnit, this.offset));
    }

    public String unitOffsetUnionString() {
        return String.format("%s-%s", this.unit, DateUtil.toSecondsString(this.offset));
    }

    public Date getOffset() {
        return this.offset;
    }

    public TimeRegionRange setOffset(Date offset) {
        this.offset = offset;
        return this;
    }

    public TimeRegionUnit getUnit() {
        return this.unit;
    }

    public TimeRegionRange setUnit(TimeRegionUnit unit) {
        this.unit = unit;
        return this;
    }

    public Date getOffsetAllUnit() {
        return this.offsetAllUnit;
    }

    public void setOffsetAllUnit(Date offsetAllUnit) {
        this.offsetAllUnit = offsetAllUnit;
    }

    public String getOffsetSimpleString() {
        return this.offsetSimpleString;
    }

    public TimeRegionRange setOffsetSimpleString(String offsetSimpleString) {
        this.offsetSimpleString = offsetSimpleString;
        return this;
    }

    @Override
    protected Function<TimeRegionRange, Object>[] showHashCodeCells() {
        Function<TimeRegionRange, Object> fn1 = TimeRegionRange::getUnit;
        Function<TimeRegionRange, Object> fn2 = TimeRegionRange::getOffset;
        Function<TimeRegionRange, Object> fn3 = TimeRegionRange::getOffsetSimpleString;
        return new Function[]{fn1, fn2, fn3};
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

