/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.report.statistics.protocol;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.exception.standard.CustomExceptionSupplier;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.date.DateRange;
import com.mini.framework.util.date.DateUtil;
import com.mini.framework.util.date.TimeSectionType;
import com.mini.framework.util.report.statistics.protocol.TimeRegionRange;
import com.mini.framework.util.type.EnumTypeShower;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.time.DateUtils;

public enum TimeRegionUnit implements EnumTypeShower<TimeRegionUnit>
{
    minute("\u5206\u949f", null, 100, Optional.empty(), TimeRegionUnit.array(new TimeRegionUnit[0])),
    hour("\u5c0f\u65f6", TimeSectionType.hour, 200, Optional.of(minute), TimeRegionUnit.array(minute)),
    day("\u81ea\u7136\u65e5", TimeSectionType.day, 300, Optional.of(hour), TimeRegionUnit.array(minute, hour)),
    week("\u81ea\u7136\u5468", TimeSectionType.week, 400, Optional.of(day), TimeRegionUnit.array(minute, hour, day)),
    month("\u81ea\u7136\u6708", TimeSectionType.month, 500, Optional.of(day), TimeRegionUnit.array(minute, hour, day)),
    season("\u81ea\u7136\u5b63", TimeSectionType.season, 600, Optional.of(month), TimeRegionUnit.array(minute, hour, day, month)),
    year("\u81ea\u7136\u5e74", TimeSectionType.year, 700, Optional.of(season), TimeRegionUnit.array(minute, hour, day, month, season)),
    all("\u6709\u53f2\u4ee5\u6765", TimeSectionType.all, 800, Optional.of(year), TimeRegionUnit.array(minute, hour, day, month, season, year));

    private String title;
    private int sizeSorter;
    private Optional<TimeRegionUnit> composeElement;
    private TimeRegionUnit[] accumulateElements;
    private TimeSectionType sectionUnit;

    @Override
    public void fillFieldToMap(Map map) {
        map.put("title", this.title);
        map.put("sizeSorter", this.sizeSorter);
        map.put("composeElement", this.composeElement);
        map.put("accumulateElements", this.accumulateElements);
        map.put("sectionUnit", this.sectionUnit);
    }

    public static <T> T[] array(T ... array) {
        return array;
    }

    private TimeRegionUnit(String title, TimeSectionType sectionUnit, int sizeSorter, Optional<TimeRegionUnit> composeElementOptional, TimeRegionUnit[] accumulateElements) {
        this.sectionUnit = sectionUnit;
        this.title = title;
        this.sizeSorter = sizeSorter;
        this.composeElement = composeElementOptional;
        this.accumulateElements = accumulateElements;
    }

    public static Comparator<TimeRegionUnit> sorterOfSize() {
        return Comparator.comparing(TimeRegionUnit::getSizeSorter);
    }

    public Optional<TimeRegionUnit> getComposeElement() {
        return this.composeElement;
    }

    public TimeSectionType getSectionUnit() {
        return this.sectionUnit;
    }

    public TimeRegionUnit validateCanAccumulateTo(TimeRegionUnit superUnit) {
        AssertUtil.assertNormal(this.canAccumulateTo(superUnit), () -> new ServerException("TimeRegionUnit:[%s]\u4e0d\u80fd\u88ab\u7ec4\u6210:[%s]", new Object[]{this, superUnit}));
        return this;
    }

    public boolean canAccumulateTo(TimeRegionUnit superUnit) {
        AssertUtil.assertMethodRequire(superUnit, "superUnit");
        return Stream.of(superUnit.accumulateElements).anyMatch(this::equals);
    }

    public String getTitle() {
        return this.title;
    }

    public int getSizeSorter() {
        return this.sizeSorter;
    }

    public TimeRegionUnit[] getAccumulateElements() {
        return this.accumulateElements;
    }

    public TimeRegionRange nearFenceRange(Date pointLimit) {
        return TimeRegionRange.create(this, this.nearLazyFenceRangeDate(pointLimit));
    }

    public boolean matchOffsetPoint(Date point) {
        return this.nearLazyFenceRangeDate(point).equals(point);
    }

    @Deprecated
    public Date nearFenceRangeDate(Date pointLimit) {
        return this.nearLazyFenceRangeDate(pointLimit);
    }

    public Date nearLazyFenceRangeDate(Date pointLimit) {
        AssertUtil.assertMethodRequire(pointLimit, "pointLimit");
        Date cleanedDate = new Date(pointLimit.getTime());
        cleanedDate = DateUtils.setMilliseconds((Date)cleanedDate, (int)0);
        cleanedDate = DateUtils.setSeconds((Date)cleanedDate, (int)0);
        if (!this.equalType(minute)) {
            cleanedDate = DateUtils.setMinutes((Date)cleanedDate, (int)0);
        }
        switch (this) {
            case all: {
                cleanedDate = new Date(0L);
                break;
            }
            case week: {
                cleanedDate = DateUtil.setWeek(cleanedDate, 0);
                break;
            }
            case year: {
                cleanedDate = DateUtils.setMonths((Date)cleanedDate, (int)0);
            }
            case season: {
                int seasonMonth = DateUtil.seasonIndex(cleanedDate) * 3;
                cleanedDate = DateUtils.setDays((Date)cleanedDate, (int)1);
                cleanedDate = DateUtils.setMonths((Date)cleanedDate, (int)seasonMonth);
            }
            case month: {
                cleanedDate = DateUtils.setDays((Date)cleanedDate, (int)1);
            }
            case day: {
                cleanedDate = DateUtils.setHours((Date)cleanedDate, (int)0);
            }
            case hour: 
            case minute: {
                break;
            }
            default: {
                throw new ServerException(Status.Server.programConfigJava, "\u65e5\u671f\u5355\u5143\u7c7b\u578b:[%s]\u65e0\u6548\u5fc5\u987b\u5904\u7406", new Object[]{this});
            }
        }
        return cleanedDate;
    }

    public static Predicate<TimeRegionUnit> elementUsefulPredicate() {
        return unit -> !unit.equalAnyType(new TimeRegionUnit[]{all});
    }

    public Date nearGreedyFenceRangeDate(Date pointLimit) {
        Date nearLazy = this.nearLazyFenceRangeDate(pointLimit);
        if (nearLazy.equals(pointLimit)) {
            return nearLazy;
        }
        return this.addTimeUnit(nearLazy, 1);
    }

    public static List<TimeRegionUnit> showElementUsefulDownSort(TimeRegionUnit minUnit, TimeRegionUnit maxUnit) {
        return Stream.of(TimeRegionUnit.values()).sorted(TimeRegionUnit.sorterOfSize().reversed()).filter(TimeRegionUnit.elementUsefulPredicate()).filter(unit -> TimeRegionUnit.sorterOfSize().compare(maxUnit, (TimeRegionUnit)unit) >= 0).filter(unit -> TimeRegionUnit.sorterOfSize().compare(minUnit, (TimeRegionUnit)unit) <= 0).collect(Collectors.toList());
    }

    public <E extends CustomException> void validateNativeDateRightPoint(DateRange dateRange, CustomExceptionSupplier<E> exceptionSupplier) throws E {
        this.validateNativeDateRightPoint(dateRange.getMinDate(), exceptionSupplier);
        this.validateNativeDateRightPoint(dateRange.getMaxDate(), exceptionSupplier);
    }

    public <E extends CustomException> void validateNativeDateRightPoint(Date datePoint, CustomExceptionSupplier<E> exceptionSupplier) throws E {
        Date rightPoint = this.nearLazyFenceRangeDate(datePoint);
        exceptionSupplier.applyAssert(rightPoint.equals(datePoint), "range\u4e2dunit:[%s]\u5f53\u524doffset:[%s]\u4e0e\u6b63\u786e\u7684offset:[%s]\u4e0d\u4e00\u81f4", new Object[]{this, datePoint.getTime(), rightPoint.getTime()});
    }

    public Date addTimeUnit(Date oldDate, int amount) {
        return TimeRegionUnit.addTimeUnit(this, oldDate, amount);
    }

    public static Date addTimeUnit(TimeRegionUnit timeUnit, Date oldDate, int amount) {
        Date newDate = null;
        switch (timeUnit) {
            case minute: {
                newDate = DateUtils.addMinutes((Date)oldDate, (int)amount);
                break;
            }
            case hour: {
                newDate = DateUtils.addHours((Date)oldDate, (int)amount);
                break;
            }
            case day: {
                newDate = DateUtils.addDays((Date)oldDate, (int)amount);
                break;
            }
            case week: {
                newDate = DateUtils.addWeeks((Date)oldDate, (int)amount);
                break;
            }
            case month: {
                newDate = DateUtils.addMonths((Date)oldDate, (int)amount);
                break;
            }
            case season: {
                newDate = DateUtils.addMonths((Date)oldDate, (int)(amount * 3));
                break;
            }
            case year: {
                newDate = DateUtils.addYears((Date)oldDate, (int)amount);
                break;
            }
            case all: {
                throw new ServerException(Status.Server.programConfigJava, "\u4e0d\u652f\u652f\u6301all\u7684\u6dfb\u52a0\u5355\u5143\u52a8\u4f5c", new Object[0]);
            }
            default: {
                throw new ServerException(Status.Server.programConfigJavaFramework, "\u7c7b\u578b\u4e3a:[%s]\u7684enum\u6ca1\u6709\u5904\u7406\u9700\u8981\u7acb\u5373\u4fee\u6539\u7a0b\u5e8f", new Object[]{timeUnit});
            }
        }
        return newDate;
    }

    public List<TimeRegionRange> findElementRegionFences(TimeRegionRange oneElementRange) {
        TimeRegionUnit elementUnit = oneElementRange.getUnit();
        elementUnit.validateCanAccumulateTo(this);
        TimeRegionRange superRange = this.nearFenceRange(oneElementRange.getOffset());
        return oneElementRange.getUnit().regionFences(superRange.getOffset(), superRange.mapperToDate());
    }

    public List<TimeRegionRange> regionFences(Date fromDate, Date toDate) {
        ArrayList<TimeRegionRange> fences = new ArrayList<TimeRegionRange>();
        Date pointDate = this.nearLazyFenceRangeDate(fromDate);
        TimeRegionRange pointFence = TimeRegionRange.create(this, pointDate);
        do {
            fences.add(pointFence);
        } while ((pointFence = pointFence.nextRegionRange()).getOffset().before(toDate));
        return fences.stream().filter(fence -> !fence.getOffset().before(fromDate)).filter(fence -> fence.getOffset().before(toDate)).collect(Collectors.toList());
    }
}

