/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.sql.view.bean;

import com.github.pagehelper.Page;
import com.mini.framework.util.sql.view.able.ObjectValueReader;
import com.mini.framework.util.sql.view.bean.ColumnDefine;
import com.mini.framework.util.sql.view.bean.RowValue;
import com.mini.framework.util.sql.view.bean.SqlViewBean;
import com.mini.framework.util.sql.view.bean.TableHead;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class TableValue
extends SqlViewBean {
    private TableHead head;
    private List<RowValue> rows;
    private Integer count;

    public static TableValue create(List<ColumnDefine> defines) {
        TableValue instance = new TableValue();
        instance.head = TableHead.create(defines);
        instance.rows = new ArrayList<RowValue>();
        return instance;
    }

    public TableValue addRow(ObjectValueReader reader) {
        RowValue row = RowValue.fromReader(reader, this.head.getColumns());
        this.rows.add(row);
        return this;
    }

    public TableValue fillFromPage(Optional<Page<?>> pageOptional) {
        pageOptional.ifPresent(page -> {
            long pageCount = page.getTotal();
            if (pageCount >= 0L) {
                this.count = (int)pageCount;
            }
        });
        return this;
    }

    public TableHead getHead() {
        return this.head;
    }

    public TableValue setHead(TableHead head) {
        this.head = head;
        return this;
    }

    public List<RowValue> getRows() {
        return this.rows;
    }

    public TableValue setRows(List<RowValue> rows) {
        this.rows = rows;
        return this;
    }

    public Integer getCount() {
        return this.count;
    }

    public TableValue setCount(Integer count) {
        this.count = count;
        return this;
    }
}

