/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string;

import com.google.gson.Gson;
import com.mini.framework.core.exception.BusyException;
import com.mini.framework.core.exception.HandleStringException;
import com.mini.framework.core.exception.HandleStringJsonException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.bean.JsonPath;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JsonEditUtil {
    private static Logger logger = LogManager.getLogger(JsonEditUtil.class);

    public static void setJsonMapNamespaceValue(Map<String, Object> map, String[] namespace, String value) {
        if (namespace == null || namespace.length == 0) {
            throw new RuntimeException(String.format("\u4ecejson map:[%s]\u4e2d\u53d6\u6570\u636e\u53c2\u6570\u4e3anull", map));
        }
        String firstNamespace = namespace[0];
        if (namespace.length == 1) {
            map.put(firstNamespace, value);
        } else {
            Map subMap = (Map)map.get(firstNamespace);
            JsonEditUtil.setJsonMapNamespaceValue(subMap, Arrays.copyOfRange(namespace, 1, namespace.length), value);
        }
    }

    public static String editJsonMapNamespaceValue(String mapFormatJson, String[] namespace, String value) {
        Gson gson = new Gson();
        Map map = (Map)gson.fromJson(mapFormatJson, Map.class);
        JsonEditUtil.setJsonMapNamespaceValue(map, namespace, value);
        String newJson = gson.toJson((Object)map);
        newJson = JsonEditUtil.lineCorrect(newJson);
        return newJson;
    }

    private static String lineCorrect(String lines) {
        if (lines != null) {
            lines = lines.replaceAll("\\\\r", "\r");
            lines = lines.replaceAll("\\\\n", "\n");
            lines = lines.replaceAll("\\\\u003c", "<");
            lines = lines.replaceAll("\\\\u003e", ">");
        }
        return lines;
    }

    public static List<String> getJsonMapNamespaceValues(String json, String[] ... namespaces) {
        Gson gson = new Gson();
        Map map = null;
        try {
            map = (Map)gson.fromJson(json, Map.class);
            return JsonEditUtil.getJsonMapNamespaceValues(map, namespaces);
        }
        catch (Exception e) {
            throw new HandleStringJsonException((Throwable)e, "\u5728\u89e3\u6790json\u65f6\u51fa\u9519\u539fjson:%s", new Object[]{json});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getJsonMapNamespaceValues(Map<String, Object> map, String[] ... namespaces) {
        ArrayList<String> values = new ArrayList<String>();
        for (Object[] objectArray : namespaces) {
            String value = null;
            try {
                value = JsonEditUtil.getJsonMapNamespaceValue(map, (String[])objectArray);
            }
            catch (Exception e) {
                logger.error("\u4ecejson\u4e2d\u53d6\u503c\u65f6\u51fa\u9519\u5c06\u8fd4\u56denull\u5e76\u5ffd\u7565,\u8bf7\u68c0\u67e5\u6570\u636e,namespace:[{}]", (Object)StringUtils.join((Object[])objectArray, (String)"->"), (Object)e);
            }
            finally {
                values.add(value);
            }
        }
        if (values.size() != namespaces.length) {
            throw new HandleStringException("\u8ba1\u7b97\u51fa\u7684\u6570\u636e:%s\u957f\u5ea6\u4e0e\u671f\u671b%s\u957f\u5ea6\u4e0d\u4e00\u81f4", new Object[]{values, namespaces.length});
        }
        return values;
    }

    public static String getJsonMapNamespaceValue(Map<String, Object> map, String[] namespace) {
        if (namespace == null || namespace.length == 0) {
            throw new RuntimeException(String.format("\u4ecejson:[%s]\u4e2d\u53d6\u6570\u636e\u53c2\u6570\u4e3anull", map));
        }
        String name = namespace[0];
        Object object = map.get(name);
        if (namespace.length == 1) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        if (object instanceof Map) {
            Map subMap = (Map)object;
            return JsonEditUtil.getJsonMapNamespaceValue(subMap, Arrays.copyOfRange(namespace, 1, namespace.length));
        }
        throw new HandleStringException("map.%s\u4e0d\u662f\u4e00\u4e2amap,map.keySet():%s,\u6570\u636e\u683c\u5f0f\u9519\u8bef", new Object[]{name, map.keySet()});
    }

    public static String getJsonMapNamespaceValue(String json, String[] namespace) {
        Gson gson = new Gson();
        Map map = null;
        try {
            map = (Map)gson.fromJson(json, Map.class);
            return JsonEditUtil.getJsonMapNamespaceValue(map, namespace);
        }
        catch (Exception e) {
            throw new HandleStringJsonException((Throwable)e, "\u5728\u89e3\u6790json\u65f6\u51fa\u9519\u539fnamespace:%s\u539fjson:%s", new Object[]{StringUtils.join((Object[])namespace, (String)","), json});
        }
    }

    public static void fillStringValue(String json, Object obj) {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            JsonPath jsonPath = field.getAnnotation(JsonPath.class);
            if (jsonPath == null) continue;
            AssertUtil.assertSupport(field.getType().equals(String.class), "\u5c5e\u6027%s\u5fc5\u987b\u662fstring", field);
            String[] namespace = jsonPath.value().split("\\.");
            String value = JsonEditUtil.getJsonMapNamespaceValue(json, namespace);
            if (value == null) continue;
            try {
                field.setAccessible(true);
                field.set(obj, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new BusyException((Throwable)e, "\u4e0d\u652f\u6301\u4fee\u6539\u6570\u636e", new Object[]{obj});
            }
        }
    }

    public static String getJsonMapNamespaceValue(String json, String path) {
        return JsonEditUtil.getJsonMapNamespaceValue(json, path.split("\\."));
    }
}

