/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.string.GsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GsonDataReader {
    private static Logger logger = LogManager.getLogger(GsonDataReader.class);
    protected Object origin;
    protected JsonElement currObject;

    public String createString() {
        return this.currObject.toString();
    }

    public String toString() {
        return this.currObject.toString();
    }

    public Object getOrigin() {
        return this.origin;
    }

    public void setOrigin(Object origin) {
        this.origin = origin;
    }

    public void init(Object object) {
        this.setOrigin(object);
        this.getCurr();
    }

    protected Gson currGsonUtil() {
        return GsonUtil.buildMilliSecondDateGson();
    }

    protected JsonElement getCurr() {
        if (this.currObject == null) {
            this.currObject = this.currGsonUtil().toJsonTree(this.origin);
        }
        return this.currObject;
    }

    protected List<JsonObject> getObject(JsonElement jsonElement, String ... names) {
        AssertUtil.assertMethodRequire(jsonElement, "jsonElement");
        AssertUtil.assertSupport(names != null && names.length >= 0, "names\u957f\u5ea6\u8981\u5927\u4e8e1", new Object[0]);
        ArrayList<JsonObject> elements = new ArrayList<JsonObject>();
        if (jsonElement.isJsonNull()) {
            return elements;
        }
        if (jsonElement.isJsonObject()) {
            if (names.length == 0) {
                elements.add(jsonElement.getAsJsonObject());
            } else {
                JsonElement subJson = jsonElement.getAsJsonObject().get(names[0]);
                if (subJson != null) {
                    elements.addAll(this.getObject(subJson, (String[])ArrayUtils.subarray((Object[])names, (int)1, (int)names.length)));
                }
            }
        } else if (jsonElement.isJsonArray()) {
            for (JsonElement subJsonElement : jsonElement.getAsJsonArray()) {
                elements.addAll(this.getObject(subJsonElement, names));
            }
        } else {
            logger.debug("\u53d1\u73b0\u4e00\u4e2a\u6ca1\u6709\u5904\u7406\u7684jsonElement, names:{},jsonElement:{}", (Object)jsonElement, (Object)Arrays.toString(names));
        }
        return elements;
    }

    protected List<Map<String, Object>> getFromListFrame(String listNamePath, String ... elementKeys) {
        return this.getFromListFrame(listNamePath, Stream.of(elementKeys).collect(Collectors.toList()));
    }

    protected List<Map<String, Object>> getFromListFrame(String listNamePath, List<String> elementKeys) {
        List<JsonObject> list = this.getObject(listNamePath);
        return list.stream().map(jsonElement -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String namespace : elementKeys) {
                Object value = this.getSingleValue((JsonElement)jsonElement, namespace).orElse(null);
                map.put(namespace, value);
            }
            return map;
        }).collect(Collectors.toList());
    }

    protected Optional<Object> getSingleValue(JsonElement jsonElement, String namespace) {
        String[] names = namespace.split("\\.");
        return this.getSingleValue(jsonElement, names);
    }

    protected Optional<Object> getSingleValue(JsonElement jsonElement, String ... names) {
        JsonElement resultTemp = jsonElement;
        for (String name : names) {
            if (resultTemp == null) {
                return Optional.empty();
            }
            if (resultTemp.isJsonNull()) {
                return Optional.empty();
            }
            if (resultTemp.isJsonPrimitive()) {
                return Optional.empty();
            }
            if (resultTemp.isJsonArray()) {
                throw new BadReqException("\u547d\u540d\u7a7a\u95f4:[%s]\u9519\u8bef,\u5b83\u5f97\u5230\u7684\u6570\u636e\u662f\u6570\u7ec4", new Object[]{String.join((CharSequence)".", names)});
            }
            if (resultTemp.isJsonObject()) {
                resultTemp = resultTemp.getAsJsonObject().get(name);
                continue;
            }
            logger.error("\u4ecejsonElement:{}\u4e2d\u53d6:{}\u51fa\u73b0\u672a\u77e5\u7684json\u7c7b\u578b", (Object)jsonElement, (Object)String.join((CharSequence)".", names));
        }
        return Optional.ofNullable(resultTemp).map(JsonElement::getAsJsonPrimitive).map(JsonPrimitive::getAsString);
    }

    protected List<JsonObject> getObject(String ... names) {
        JsonElement element = this.getCurr();
        return this.getObject(element, names);
    }

    protected List<JsonObject> getObject(String namespace) {
        String[] names = namespace.split("\\.");
        if (names[0].length() == 0) {
            names = new String[]{};
        }
        return this.getObject(names);
    }
}

