/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.util.string.gson.deserializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface UnknownTypeHelper {
    public static Object parseUnknownTypeValue(Number number) {
        AssertUtil.assertMethodRequire(number, "number");
        String string = number.toString();
        if (StringUtils.isNumeric((CharSequence)number.toString())) {
            long longValue = number.longValue();
            if (longValue >= 0L && longValue <= Integer.MAX_VALUE) {
                return number.intValue();
            }
            if (longValue <= 0L && longValue >= Integer.MIN_VALUE) {
                return number.intValue();
            }
            if (string.equals(String.valueOf(longValue))) {
                return longValue;
            }
            return number.doubleValue();
        }
        return number.doubleValue();
    }

    default public void fillUnknownValueToMap(JsonElement json, Map<String, Object> map) {
        JsonObject jsonObject = json.getAsJsonObject();
        Set entrySet = jsonObject.entrySet();
        for (Map.Entry entry : entrySet) {
            JsonPrimitive primitive;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof JsonElement) || !((JsonElement)value).isJsonPrimitive() || !(primitive = ((JsonElement)value).getAsJsonPrimitive()).isNumber()) continue;
            Number number = primitive.getAsNumber();
            map.put(key, UnknownTypeHelper.parseUnknownTypeValue(number));
        }
    }
}

