package com.mini.framework.util.access;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;

public class AccessTokenResp {

	private String token;

	private String[] paramArray;
	
	private String paramString;
	
	private String desc = "功能说明:token将是去异构系统中批量查询数据的凭证，包含过期时间和paramString的加密信息，用于保证普通用户只查被授权的数据。"
			+ "\n例如:某用户X在A系统到查到100个订单，涉及了20个付款人的信息(假如是头像等)，那么系统短暂的允许用户X去用户系统中查询这20个付款主人的信息。\n"
			+ "这个时候token就是允许用户X去用户系统查询信息的凭证，用户X必须在给定的过期时间内且正好是给定的参数序列paramString才能正常使用";
	

	
	public AccessTokenResp() {
		super();
	}

	public AccessTokenResp(String token, String[] paramArray) {
		super();
		AssertUtil.assertMethodRequire(token, "token");
		AssertUtil.assertMethodRequire(paramArray, "paramArray");
		this.token = token;
		this.paramArray =paramArray;
		this.paramString = StringUtils.join(paramArray,",");
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}
	
	
	public String[] getParamArray() {
		return paramArray;
	}

	public void setParamArray(String[] paramArray) {
		this.paramArray = paramArray;
	}

	public String getParamString() {
		return paramString;
	}

	public void setParamString(String paramString) {
		this.paramString = paramString;
	}
	
	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
