package com.mini.framework.util.asserts;

import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.flag.DatabaseInstanceMapper;

import java.util.Optional;
import java.util.function.Function;

/**
 * bean实体的断言器
 * @author jayheo
 */
public class AssertBean {




    /**
     * 从bean得到不能为空的 field
     * */
    public static <B,R,E extends CustomException> R requireFieldFromBean(B bean, Function<B,R> fieldGetter, Function<String,E> exceptionSupplier, String errorMessage, Object... errorParams) throws E{
        R field = fieldGetter.apply(bean);
        AssertUtil.assertNormal(field!=null,exceptionSupplier,errorMessage,errorParams);
        return field;
    }


    /**
     * 从bean得到不能为空的 field
     * */
    public static <B,R> R requireFieldFromBean(B bean, Function<B,R> fieldGetter, StatusCode errorCode,String errorMessage,Object... errorParams){
        R field = fieldGetter.apply(bean);
        AssertUtil.assertMethodRequire(fieldGetter,"fieldGetter");
        AssertUtil.simpleAssertByStatus(field!=null,errorCode,errorMessage,errorParams);
        return field;
    }


    /**
     * 从 数据库对应的 bean 得到不能为空的 field
     * */
    public static <B,R> R requireFieldFromDatabaseBean(B bean, Function<B,R> fieldGetter, Optional<Object> keyOptional, String fieldName, String instanceName){
        AssertUtil.assertMethodRequire(bean,"bean");
        return requireFieldFromBean(bean,fieldGetter, Status.BadData.missRequireFieldData,"类型为:[%s]的db实体key:[%s]中缺失非空属性:[%s]",instanceName,keyOptional.orElse(null),fieldName);
    }

    /**
     * 从 数据库对应的 bean 得到不能为空的 field
     * */
    public static <B extends DatabaseInstanceMapper,R> R requireFieldFromDatabaseBean(B bean, Function<B,R> fieldGetter, String fieldName){
        AssertUtil.assertMethodRequire(bean,"bean");
        return requireFieldFromDatabaseBean(bean,fieldGetter,bean.showDatabaseInstanceKey(),fieldName,bean.showDatabaseInstanceName());
    }


    /**
     * 从 数据库对应的 bean 得到不能为空的 field
     * */
    public static <B extends DatabaseInstanceMapper,R> R requireFieldFromDatabaseBean(B bean, R fieldNullable, String fieldName){
        return requireFieldFromDatabaseBean(bean,b->fieldNullable,fieldName);
    }

}
