package com.mini.framework.util.asserts;

import org.apache.commons.lang3.StringUtils;

import com.mini.framework.core.exception.standard.UnsupportedException;

public class JudgeUtil {
	
	public static boolean match(Object object,Require require,Object ... params){
		switch (require) {
		case isTrue:
			//TODO 要断言数据类型
			return (boolean) object;
		case arrLength:
			return params!=null&&
					((Integer)object)==params.length;
		case equals:
			return match(object, Require.notNull) &&
					match(1,Require.arrLength,params) &&//长度为1
					object.equals(params[0]);
		case notNull:
			return object != null;
		case notEmpty:
			return match(object, Require.notNull) &&
			object.toString().length() > 0;
		case mobileFormat:
			return object!=null &&
			StringUtils.isNumeric(object.toString()) &&
			StringUtils.length(object.toString()) == 11;
		case openIdFormat:
			return match(object, Require.notEmpty) &&
					((String)object).length() >=28 &&
					((String)object).length() <=32 ;
		case isNumber:
			return match(object, Require.notNull) &&
					StringUtils.isNumeric((String)object);
		case between:
			return match(2, Require.arrLength,params) &&//长度必须为2
					(object instanceof Comparable<?>) &&//类型检查
					match(object.getClass().getTypeName(), Require.equals,params[0].getClass().getTypeName()) &&
					match(object.getClass().getTypeName(), Require.equals,params[1].getClass().getTypeName()) &&
					((Comparable)(object)).compareTo(params[0]) >= 0 && //最小值检查
					((Comparable)(object)).compareTo(params[1]) < 0;//最大值检查
					
		case trimNotEmpty :
			return match(object, Require.notEmpty) &&
					match(((String)object).trim(), Require.notEmpty);
					
		case phone:
			return match(object, Require.isNumber, params) &&
					//TODO 以后要更加精细话
					object.toString().length() == 11 &&
							object.toString().substring(0,1).equals("1");
		case emailFormat:
		
		default:
			throw new UnsupportedException("不支持的类型object:%s,Require:%s",object,require);
		}
		
	}
}
