package com.mini.framework.util.asserts;


import org.apache.commons.lang3.ArrayUtils;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;

/**
 * 类型切换控制器
 * 用户辅助类型状态流转
 * @author jayheo
 *
 */
public interface TypeSwitchAssert{

	/**
	 * 检查是不是可以到下一个流程
	 * 也就是说下一个流程的名字在不在nexts里面
	 * @param next
	 * @return
	 */
	default public <T extends TypeSwitchAssert> T validateNext(T next,StatusCode status,String message,Object ... params) {
		AssertUtil.assertNoBadReq(ifNext(next),status, message, params);
		return next;
	}


	/**
	 * 请使用
	 * @see #validateNext(TypeSwitchAssert, StatusCode, String, Object...)
	 * */
	@Deprecated
	default public <T extends TypeSwitchAssert> T valiNext(T next,StatusCode status,String message,Object ... params) {
		return validateNext(next, status, message, params);
	}


	/**
	 * 请使用
	 * @see #validateNext(TypeSwitchAssert)
	 * */
	@Deprecated
	default public <T extends TypeSwitchAssert> T valiNext(T next) {
		return validateNext(next);
	}
	default public <T extends TypeSwitchAssert> T validateNext(T next) {
		return valiNext(next, Status.BadReq.statusSwitch, "状态:[%s]不能切换到状态:[%s]", this.showSelfTitle(),next.showSelfTitle());
	}
	
	default public <T extends TypeSwitchAssert> boolean ifNext(T next) {
		AssertUtil.assertMethodRequire(next, "next");
		String[] nexts = showNexts();
		int index = ArrayUtils.indexOf(nexts, next.toString());
		return index>=0;
	}
	
	/**
	 * 是不终态
	 * 这个方法有bug
	 * @see #ifEndStatus()
	 * @return
	 */
	@Deprecated
	default public boolean ifFinalStatus (){
		String[] nexts = showNexts();
		return nexts.length>0;
	}

	/**
	 * 是不终态
	 * */
	default public boolean ifEndStatus (){
		String[] nexts = showNexts();
		return nexts.length == 0;
	}

	
	//TODO 检查当前这个枚举的next数据是不是都在允许以内
	
	/**
	 * 显示可能的下一个状态的名字
	 * @return
	 */
	public String[] showNexts();
	
	/**
	 * 显示 自己的名字
	 * @return
	 */
	default String showSelfName(){
		return this.toString();
	}
	
	default String showSelfTitle(){
		return showSelfName();
	}
	
	
}
