package com.mini.framework.util.bean;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;

import org.apache.commons.lang.math.RandomUtils;

/**
 * 加权随机工具类
 * @author jayheo
 *
 */
public class WeightRandomUtil {
	

	public static <B extends WeightBean,R> Optional<R> nextBean(Collection<B> beans,Function<B, R> fieldGetter){
		return nextBean(beans).map(fieldGetter);
	}
	
	
	/**
	 * 找到那个符合条件bean
	 * @param beans
	 * @return
	 */
	public static <B extends WeightBean> Optional<B> nextBean(Collection<B> beans){
		double sum = sumWeight(beans);
		double randomValue = RandomUtils.nextDouble() * sum;
		B scanBean = null; 
		double accumulateValue = 0;
		for (B bean : beans) {
			accumulateValue += bean.showWeight();
			if(accumulateValue >randomValue ){
				return Optional.of(bean);
			}
			scanBean = bean;
		}
		
		return Optional.ofNullable(scanBean);
	}
	

	/**
	 * 权重求和
	 * @param beans
	 * @return
	 */
	public static <B extends WeightBean> double sumWeight(Collection<B> beans){
		double sum = beans.stream().mapToDouble(WeightBean::showWeight).sum();
		return sum;
	}
	
}
