package com.mini.framework.util.bean.desc;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mini.framework.util.bean.BeanUtil;

public class DescSerializer implements JsonSerializer<Descable> {

	private String suffix;
	
	private String nullDesc;

	private Supplier<Gson> gsonSupplier;
	

	public DescSerializer(String suffix, Supplier<Gson> gsonSupplier,String nullDesc) {
		super();
		this.suffix = suffix;
		this.gsonSupplier = gsonSupplier;
		this.nullDesc = nullDesc;
	}

	@Override
	public JsonElement serialize(Descable desc, Type typeOfSrc, JsonSerializationContext context) {
		Map<String, Object> map = BeanUtil.beanToMap(desc);
		List<Field> fields = BeanUtil.getAllField(desc);
		Map<String, FieldDesc> keyDescMap = fields.stream().collect(Collectors.toMap(field->field.getName() + suffix,field->DescUtil.getDesces(field, nullDesc)));
		map.putAll(keyDescMap);
		Map<String, Object> newMap = new LinkedHashMap<>();
		map.keySet().stream().sorted().forEach(key->newMap.put(key, map.get(key)));
		Gson gson = gsonSupplier.get();
		JsonElement element = gson.toJsonTree(newMap);
		return element;
	}
}
