package com.mini.framework.util.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * 冻结一个function，以保证同样的参数，只被执行一次
 * 一般来说， 这个T是要基本数据类型可以被equals的
 * @author jayheo
 *
 * @param <T>
 * @param <R>
 */
public class HoldFunction<T,R> implements Function<T, R>{

	private Map<T, R> cacheMapper = new HashMap<>();
	/**
	 * 标记一下这个有没有被使用，主要是解决null值被多次执行的问题
	 */
	private Set<T> executeFlag = new HashSet<>();
	
	private Function<T, R> function = null;
	
	private HoldFunction(Function<T, R> function) {
		super();
		this.function = function;
	}

	public static <T,R> HoldFunction<T, R> create(Function<T, R> function){
		AssertUtil.assertMethodRequire(function, "function");
		return new HoldFunction<>(function);
	}


	@Override
	public R apply(T t) {
		if(executeFlag.contains(t)){
			return cacheMapper.get(t);
		}else{
			executeFlag.add(t);
			R r = function.apply(t);
			cacheMapper.put(t, r);
			return r;
		}
	}
	
	public void clear(){
		executeFlag.clear();
		cacheMapper.clear();
	}
}
