package com.mini.framework.util.cache.annotation.springboot2;

import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.paas.SiteIdReader;

/**
 * 多商家redis缓存
 * 当有多个商家的时候应该保证各个商家数据不干扰
 * @author jayheo
 *
 * @param <S>
 */
public class AbstractMultiSiteRedisCacheSupport<S> extends AbstractRedisCacheSupport{
	
	private SiteIdReader<S> siteIdReader;

	public AbstractMultiSiteRedisCacheSupport(JedisConnectionFactory jedisConnectionFactory, String cacheNamespace,SiteIdReader<S> siteIdReader) {
		this.siteIdReader = siteIdReader;
		AssertUtil.assertNotFatal(this.siteIdReader !=null, "siteIdReader不能为空");
		afterInit(jedisConnectionFactory, cacheNamespace);
	}
	
	public AbstractMultiSiteRedisCacheSupport(RedisConnectConfig redisConnectConfig, String cacheNamespace,SiteIdReader<S> siteIdReader) {
		this(createJedisConnectionFactory(redisConnectConfig.getHost(), redisConnectConfig.getPort(), redisConnectConfig.getPassword(),redisConnectConfig.getDatabase(), redisConnectConfig.getTimeout()), cacheNamespace,siteIdReader);
	}
	
	
	@Override
	protected CustomCacheKeyPrefix createKeyPrefix(String cacheNamespace) {
		return new MultiSiteCustomCacheKeyPrefix<S>(cacheNamespace,siteIdReader);
	}

}
