package com.mini.framework.util.cache.annotation.springboot2;

import org.springframework.data.redis.cache.CacheKeyPrefix;

import com.mini.framework.util.asserts.AssertUtil;

public class CustomCacheKeyPrefix implements CacheKeyPrefix {

	protected String cacheNamespace;

	public static final String saveSplit = ":";
	public static final String expireSplit = "#";

	public CustomCacheKeyPrefix(String cacheNamespace) {
		super();
		AssertUtil.assertNotFatal(cacheNamespace!=null, "cacheNamespace前缀没有配置");
		this.cacheNamespace = cacheNamespace;
	}
	

	@Override
	public String compute(String cacheName) {
		cacheName = cacheName.split(expireSplit)[0];
		return fillKeyPrefix(cacheName);
	}
	
	/**
	 * @param cacheName
	 * @return
	 */
	public String fillKeyPrefix(String key) {
		AssertUtil.assertNotFatal(cacheNamespace!=null, "cacheNamespace前缀没有配置");
		return String.join(saveSplit, cacheNamespace.toString(),key,"");
	}
}
